/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class DescribeDefaultClusterParametersIterable
implements SdkIterable<DescribeDefaultClusterParametersResponse> {
    private final RedshiftClient client;
    private final DescribeDefaultClusterParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDefaultClusterParametersIterable(RedshiftClient client, DescribeDefaultClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDefaultClusterParametersResponseFetcher();
    }

    public Iterator<DescribeDefaultClusterParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDefaultClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.defaultClusterParameters() != null && response.defaultClusterParameters().parameters() != null) {
                return response.defaultClusterParameters().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDefaultClusterParametersIterable resume(DescribeDefaultClusterParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDefaultClusterParametersIterable(this.client, (DescribeDefaultClusterParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.defaultClusterParameters().marker()).build()));
        }
        return new DescribeDefaultClusterParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDefaultClusterParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDefaultClusterParametersResponseFetcher
    implements SyncPageFetcher<DescribeDefaultClusterParametersResponse> {
        private DescribeDefaultClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDefaultClusterParametersResponse previousPage) {
            return previousPage.defaultClusterParameters().marker() != null;
        }

        public DescribeDefaultClusterParametersResponse nextPage(DescribeDefaultClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDefaultClusterParametersIterable.this.client.describeDefaultClusterParameters(DescribeDefaultClusterParametersIterable.this.firstRequest);
            }
            return DescribeDefaultClusterParametersIterable.this.client.describeDefaultClusterParameters((DescribeDefaultClusterParametersRequest)((Object)DescribeDefaultClusterParametersIterable.this.firstRequest.toBuilder().marker(previousPage.defaultClusterParameters().marker()).build()));
        }
    }
}

