/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;

public class DescribeClusterParameterGroupsPublisher
implements SdkPublisher<DescribeClusterParameterGroupsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterParameterGroupsPublisher(RedshiftAsyncClient client, DescribeClusterParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterParameterGroupsPublisher(RedshiftAsyncClient client, DescribeClusterParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ClusterParameterGroup> parameterGroups() {
        Function<DescribeClusterParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameterGroups() != null) {
                return response.parameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeClusterParameterGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeClusterParameterGroupsPublisher resume(DescribeClusterParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterParameterGroupsPublisher(this.client, (DescribeClusterParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterParameterGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterParameterGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterParameterGroupsResponse> {
        private DescribeClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeClusterParameterGroupsResponse> nextPage(DescribeClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParameterGroupsPublisher.this.client.describeClusterParameterGroups(DescribeClusterParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeClusterParameterGroupsPublisher.this.client.describeClusterParameterGroups((DescribeClusterParameterGroupsRequest)((Object)DescribeClusterParameterGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

