/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;
import software.amazon.awssdk.services.redshift.model.ReservedNodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedNodesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeReservedNodesResponse> {
    private final String marker;
    private final List<ReservedNode> reservedNodes;

    private DescribeReservedNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodes = builder.reservedNodes;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedNode> reservedNodes() {
        return this.reservedNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesResponse)) {
            return false;
        }
        DescribeReservedNodesResponse other = (DescribeReservedNodesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedNodes(), other.reservedNodes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedNodesResponse").add("Marker", (Object)this.marker()).add("ReservedNodes", this.reservedNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedNodes": {
                return Optional.of(clazz.cast(this.reservedNodes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNode> reservedNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedNodes(model.reservedNodes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNode.Builder> getReservedNodes() {
            return this.reservedNodes != null ? (Collection)this.reservedNodes.stream().map(ReservedNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(ReservedNode ... reservedNodes) {
            this.reservedNodes(Arrays.asList(reservedNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(Consumer<ReservedNode.Builder> ... reservedNodes) {
            this.reservedNodes(Stream.of(reservedNodes).map(c -> (ReservedNode)((ReservedNode.Builder)ReservedNode.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedNodes(Collection<ReservedNode.BuilderImpl> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copyFromBuilder(reservedNodes);
        }

        @Override
        public DescribeReservedNodesResponse build() {
            return new DescribeReservedNodesResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedNodesResponse> {
        public Builder marker(String var1);

        public Builder reservedNodes(Collection<ReservedNode> var1);

        public Builder reservedNodes(ReservedNode ... var1);

        public Builder reservedNodes(Consumer<ReservedNode.Builder> ... var1);
    }
}

