/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EventCategoriesMap;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;
import software.amazon.awssdk.services.redshift.transform.EventInfoMapUnmarshaller;

public class EventCategoriesMapUnmarshaller
implements Unmarshaller<EventCategoriesMap, StaxUnmarshallerContext> {
    private static EventCategoriesMapUnmarshaller INSTANCE;

    public EventCategoriesMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EventCategoriesMap.Builder eventCategoriesMap = EventCategoriesMap.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceType", targetDepth)) {
                    eventCategoriesMap.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Events", targetDepth)) {
                    eventCategoriesMap.events(new ArrayList<EventInfoMap>());
                    continue;
                }
                if (!context.testExpression("Events/EventInfoMap", targetDepth)) continue;
                eventCategoriesMap.events(EventInfoMapUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EventCategoriesMap)eventCategoriesMap.build();
    }

    public static EventCategoriesMapUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventCategoriesMapUnmarshaller();
        }
        return INSTANCE;
    }
}

