/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeHsmClientCertificatesRequestMarshaller
implements Marshaller<Request<DescribeHsmClientCertificatesRequest>, DescribeHsmClientCertificatesRequest> {
    public Request<DescribeHsmClientCertificatesRequest> marshall(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeHsmClientCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHsmClientCertificatesRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeHsmClientCertificates");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmClientCertificatesRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)describeHsmClientCertificatesRequest.hsmClientCertificateIdentifier()));
        }
        if (describeHsmClientCertificatesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeHsmClientCertificatesRequest.maxRecords()));
        }
        if (describeHsmClientCertificatesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeHsmClientCertificatesRequest.marker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeHsmClientCertificatesRequest.tagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeHsmClientCertificatesRequest.tagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

