/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeTagsRequest> {
    private final String resourceName;
    private final String resourceType;
    private final Integer maxRecords;
    private final String marker;
    private final List<String> tagKeys;
    private final List<String> tagValues;

    private DescribeTagsRequest(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        hashCode = 31 * hashCode + (this.tagValues() == null ? 0 : this.tagValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest)((Object)obj);
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        if (other.tagValues() == null ^ this.tagValues() == null) {
            return false;
        }
        return other.tagValues() == null || other.tagValues().equals(this.tagValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (this.tagValues() != null) {
            sb.append("TagValues: ").append(this.tagValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String resourceType;
        private Integer maxRecords;
        private String marker;
        private List<String> tagKeys = new SdkInternalList();
        private List<String> tagValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            this.setResourceName(model.resourceName);
            this.setResourceType(model.resourceType);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
            this.setTagKeys(model.tagKeys);
            this.setTagValues(model.tagValues);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
        }

        public final Collection<String> getTagValues() {
            return this.tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @SafeVarargs
        public final void setTagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
        }

        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsRequest> {
        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

