/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSubnetGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeClusterSubnetGroupsRequest> {
    private final String clusterSubnetGroupName;
    private final Integer maxRecords;
    private final String marker;
    private final List<String> tagKeys;
    private final List<String> tagValues;

    private DescribeClusterSubnetGroupsRequest(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterSubnetGroupName() == null ? 0 : this.clusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        hashCode = 31 * hashCode + (this.tagValues() == null ? 0 : this.tagValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSubnetGroupsRequest)) {
            return false;
        }
        DescribeClusterSubnetGroupsRequest other = (DescribeClusterSubnetGroupsRequest)((Object)obj);
        if (other.clusterSubnetGroupName() == null ^ this.clusterSubnetGroupName() == null) {
            return false;
        }
        if (other.clusterSubnetGroupName() != null && !other.clusterSubnetGroupName().equals(this.clusterSubnetGroupName())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        if (other.tagValues() == null ^ this.tagValues() == null) {
            return false;
        }
        return other.tagValues() == null || other.tagValues().equals(this.tagValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (this.tagValues() != null) {
            sb.append("TagValues: ").append(this.tagValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private Integer maxRecords;
        private String marker;
        private List<String> tagKeys = new SdkInternalList();
        private List<String> tagValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSubnetGroupsRequest model) {
            this.setClusterSubnetGroupName(model.clusterSubnetGroupName);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
            this.setTagKeys(model.tagKeys);
            this.setTagValues(model.tagValues);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
        }

        public final Collection<String> getTagValues() {
            return this.tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @SafeVarargs
        public final void setTagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
        }

        public DescribeClusterSubnetGroupsRequest build() {
            return new DescribeClusterSubnetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterSubnetGroupsRequest> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

