/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.RdsDataRequest;
import software.amazon.awssdk.services.rdsdata.model.SqlParameter;
import software.amazon.awssdk.services.rdsdata.model.SqlParameterSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementRequest
extends RdsDataRequest
implements ToCopyableBuilder<Builder, BatchExecuteStatementRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::resourceArn)).setter(BatchExecuteStatementRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::secretArn)).setter(BatchExecuteStatementRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<String> SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sql").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sql)).setter(BatchExecuteStatementRequest.setter(Builder::sql)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("database").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::database)).setter(BatchExecuteStatementRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::schema)).setter(BatchExecuteStatementRequest.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<List<List<SqlParameter>>> PARAMETER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterSets").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::parameterSets)).setter(BatchExecuteStatementRequest.setter(Builder::parameterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::transactionId)).setter(BatchExecuteStatementRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SECRET_ARN_FIELD, SQL_FIELD, DATABASE_FIELD, SCHEMA_FIELD, PARAMETER_SETS_FIELD, TRANSACTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("secretArn", SECRET_ARN_FIELD);
            this.put("sql", SQL_FIELD);
            this.put("database", DATABASE_FIELD);
            this.put("schema", SCHEMA_FIELD);
            this.put("parameterSets", PARAMETER_SETS_FIELD);
            this.put("transactionId", TRANSACTION_ID_FIELD);
        }
    });
    private final String resourceArn;
    private final String secretArn;
    private final String sql;
    private final String database;
    private final String schema;
    private final List<List<SqlParameter>> parameterSets;
    private final String transactionId;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.database = builder.database;
        this.schema = builder.schema;
        this.parameterSets = builder.parameterSets;
        this.transactionId = builder.transactionId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String sql() {
        return this.sql;
    }

    public final String database() {
        return this.database;
    }

    public final String schema() {
        return this.schema;
    }

    public final boolean hasParameterSets() {
        return this.parameterSets != null && !(this.parameterSets instanceof SdkAutoConstructList);
    }

    public final List<List<SqlParameter>> parameterSets() {
        return this.parameterSets;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterSets() ? this.parameterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sql(), other.sql()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.schema(), other.schema()) && this.hasParameterSets() == other.hasParameterSets() && Objects.equals(this.parameterSets(), other.parameterSets()) && Objects.equals(this.transactionId(), other.transactionId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementRequest").add("ResourceArn", (Object)this.resourceArn()).add("SecretArn", (Object)this.secretArn()).add("Sql", (Object)this.sql()).add("Database", (Object)this.database()).add("Schema", (Object)this.schema()).add("ParameterSets", this.hasParameterSets() ? this.parameterSets() : null).add("TransactionId", (Object)this.transactionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "sql": {
                return Optional.ofNullable(clazz.cast(this.sql()));
            }
            case "database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "parameterSets": {
                return Optional.ofNullable(clazz.cast(this.parameterSets()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String secretArn;
        private String sql;
        private String database;
        private String schema;
        private List<List<SqlParameter>> parameterSets = DefaultSdkAutoConstructList.getInstance();
        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.secretArn(model.secretArn);
            this.sql(model.sql);
            this.database(model.database);
            this.schema(model.schema);
            this.parameterSets(model.parameterSets);
            this.transactionId(model.transactionId);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSql() {
            return this.sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final List<List<SqlParameter.Builder>> getParameterSets() {
            List<List<SqlParameter.Builder>> result = SqlParameterSetsCopier.copyToBuilder(this.parameterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterSets(Collection<? extends Collection<SqlParameter.BuilderImpl>> parameterSets) {
            this.parameterSets = SqlParameterSetsCopier.copyFromBuilder(parameterSets);
        }

        @Override
        public final Builder parameterSets(Collection<? extends Collection<SqlParameter>> parameterSets) {
            this.parameterSets = SqlParameterSetsCopier.copy(parameterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterSets(Collection<SqlParameter> ... parameterSets) {
            this.parameterSets((Collection<? extends Collection<SqlParameter>>)Arrays.asList(parameterSets));
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        public Builder resourceArn(String var1);

        public Builder secretArn(String var1);

        public Builder sql(String var1);

        public Builder database(String var1);

        public Builder schema(String var1);

        public Builder parameterSets(Collection<? extends Collection<SqlParameter>> var1);

        public Builder parameterSets(Collection<SqlParameter> ... var1);

        public Builder transactionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

