/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZone;
import software.amazon.awssdk.services.rds.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeature;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderableDBInstanceOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderableDBInstanceOption> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::engine)).setter(OrderableDBInstanceOption.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::engineVersion)).setter(OrderableDBInstanceOption.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::dbInstanceClass)).setter(OrderableDBInstanceOption.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::licenseModel)).setter(OrderableDBInstanceOption.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::availabilityZones)).setter(OrderableDBInstanceOption.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::multiAZCapable)).setter(OrderableDBInstanceOption.setter(Builder::multiAZCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZCapable").build()}).build();
    private static final SdkField<Boolean> READ_REPLICA_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::readReplicaCapable)).setter(OrderableDBInstanceOption.setter(Builder::readReplicaCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaCapable").build()}).build();
    private static final SdkField<Boolean> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::vpc)).setter(OrderableDBInstanceOption.setter(Builder::vpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsStorageEncryption)).setter(OrderableDBInstanceOption.setter(Builder::supportsStorageEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageEncryption").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::storageType)).setter(OrderableDBInstanceOption.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsIops)).setter(OrderableDBInstanceOption.setter(Builder::supportsIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIops").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsEnhancedMonitoring)).setter(OrderableDBInstanceOption.setter(Builder::supportsEnhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsEnhancedMonitoring").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsIAMDatabaseAuthentication)).setter(OrderableDBInstanceOption.setter(Builder::supportsIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsPerformanceInsights)).setter(OrderableDBInstanceOption.setter(Builder::supportsPerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsPerformanceInsights").build()}).build();
    private static final SdkField<Integer> MIN_STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minStorageSize)).setter(OrderableDBInstanceOption.setter(Builder::minStorageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageSize").build()}).build();
    private static final SdkField<Integer> MAX_STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxStorageSize)).setter(OrderableDBInstanceOption.setter(Builder::maxStorageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageSize").build()}).build();
    private static final SdkField<Integer> MIN_IOPS_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minIopsPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::minIopsPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerDbInstance").build()}).build();
    private static final SdkField<Integer> MAX_IOPS_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxIopsPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::maxIopsPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerDbInstance").build()}).build();
    private static final SdkField<Double> MIN_IOPS_PER_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minIopsPerGib)).setter(OrderableDBInstanceOption.setter(Builder::minIopsPerGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerGib").build()}).build();
    private static final SdkField<Double> MAX_IOPS_PER_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxIopsPerGib)).setter(OrderableDBInstanceOption.setter(Builder::maxIopsPerGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerGib").build()}).build();
    private static final SdkField<List<AvailableProcessorFeature>> AVAILABLE_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::availableProcessorFeatures)).setter(OrderableDBInstanceOption.setter(Builder::availableProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProcessorFeatures").build(), ListTrait.builder().memberLocationName("AvailableProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailableProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportedEngineModes)).setter(OrderableDBInstanceOption.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_AUTOSCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsStorageAutoscaling)).setter(OrderableDBInstanceOption.setter(Builder::supportsStorageAutoscaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageAutoscaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_INSTANCE_CLASS_FIELD, LICENSE_MODEL_FIELD, AVAILABILITY_ZONES_FIELD, MULTI_AZ_CAPABLE_FIELD, READ_REPLICA_CAPABLE_FIELD, VPC_FIELD, SUPPORTS_STORAGE_ENCRYPTION_FIELD, STORAGE_TYPE_FIELD, SUPPORTS_IOPS_FIELD, SUPPORTS_ENHANCED_MONITORING_FIELD, SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD, SUPPORTS_PERFORMANCE_INSIGHTS_FIELD, MIN_STORAGE_SIZE_FIELD, MAX_STORAGE_SIZE_FIELD, MIN_IOPS_PER_DB_INSTANCE_FIELD, MAX_IOPS_PER_DB_INSTANCE_FIELD, MIN_IOPS_PER_GIB_FIELD, MAX_IOPS_PER_GIB_FIELD, AVAILABLE_PROCESSOR_FEATURES_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTS_STORAGE_AUTOSCALING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String dbInstanceClass;
    private final String licenseModel;
    private final List<AvailabilityZone> availabilityZones;
    private final Boolean multiAZCapable;
    private final Boolean readReplicaCapable;
    private final Boolean vpc;
    private final Boolean supportsStorageEncryption;
    private final String storageType;
    private final Boolean supportsIops;
    private final Boolean supportsEnhancedMonitoring;
    private final Boolean supportsIAMDatabaseAuthentication;
    private final Boolean supportsPerformanceInsights;
    private final Integer minStorageSize;
    private final Integer maxStorageSize;
    private final Integer minIopsPerDbInstance;
    private final Integer maxIopsPerDbInstance;
    private final Double minIopsPerGib;
    private final Double maxIopsPerGib;
    private final List<AvailableProcessorFeature> availableProcessorFeatures;
    private final List<String> supportedEngineModes;
    private final Boolean supportsStorageAutoscaling;

    private OrderableDBInstanceOption(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.licenseModel = builder.licenseModel;
        this.availabilityZones = builder.availabilityZones;
        this.multiAZCapable = builder.multiAZCapable;
        this.readReplicaCapable = builder.readReplicaCapable;
        this.vpc = builder.vpc;
        this.supportsStorageEncryption = builder.supportsStorageEncryption;
        this.storageType = builder.storageType;
        this.supportsIops = builder.supportsIops;
        this.supportsEnhancedMonitoring = builder.supportsEnhancedMonitoring;
        this.supportsIAMDatabaseAuthentication = builder.supportsIAMDatabaseAuthentication;
        this.supportsPerformanceInsights = builder.supportsPerformanceInsights;
        this.minStorageSize = builder.minStorageSize;
        this.maxStorageSize = builder.maxStorageSize;
        this.minIopsPerDbInstance = builder.minIopsPerDbInstance;
        this.maxIopsPerDbInstance = builder.maxIopsPerDbInstance;
        this.minIopsPerGib = builder.minIopsPerGib;
        this.maxIopsPerGib = builder.maxIopsPerGib;
        this.availableProcessorFeatures = builder.availableProcessorFeatures;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportsStorageAutoscaling = builder.supportsStorageAutoscaling;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public Boolean multiAZCapable() {
        return this.multiAZCapable;
    }

    public Boolean readReplicaCapable() {
        return this.readReplicaCapable;
    }

    public Boolean vpc() {
        return this.vpc;
    }

    public Boolean supportsStorageEncryption() {
        return this.supportsStorageEncryption;
    }

    public String storageType() {
        return this.storageType;
    }

    public Boolean supportsIops() {
        return this.supportsIops;
    }

    public Boolean supportsEnhancedMonitoring() {
        return this.supportsEnhancedMonitoring;
    }

    public Boolean supportsIAMDatabaseAuthentication() {
        return this.supportsIAMDatabaseAuthentication;
    }

    public Boolean supportsPerformanceInsights() {
        return this.supportsPerformanceInsights;
    }

    public Integer minStorageSize() {
        return this.minStorageSize;
    }

    public Integer maxStorageSize() {
        return this.maxStorageSize;
    }

    public Integer minIopsPerDbInstance() {
        return this.minIopsPerDbInstance;
    }

    public Integer maxIopsPerDbInstance() {
        return this.maxIopsPerDbInstance;
    }

    public Double minIopsPerGib() {
        return this.minIopsPerGib;
    }

    public Double maxIopsPerGib() {
        return this.maxIopsPerGib;
    }

    public List<AvailableProcessorFeature> availableProcessorFeatures() {
        return this.availableProcessorFeatures;
    }

    public List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public Boolean supportsStorageAutoscaling() {
        return this.supportsStorageAutoscaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.readReplicaCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsEnhancedMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsPerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIopsPerGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIopsPerGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEngineModes());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageAutoscaling());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.multiAZCapable(), other.multiAZCapable()) && Objects.equals(this.readReplicaCapable(), other.readReplicaCapable()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.supportsStorageEncryption(), other.supportsStorageEncryption()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.supportsIops(), other.supportsIops()) && Objects.equals(this.supportsEnhancedMonitoring(), other.supportsEnhancedMonitoring()) && Objects.equals(this.supportsIAMDatabaseAuthentication(), other.supportsIAMDatabaseAuthentication()) && Objects.equals(this.supportsPerformanceInsights(), other.supportsPerformanceInsights()) && Objects.equals(this.minStorageSize(), other.minStorageSize()) && Objects.equals(this.maxStorageSize(), other.maxStorageSize()) && Objects.equals(this.minIopsPerDbInstance(), other.minIopsPerDbInstance()) && Objects.equals(this.maxIopsPerDbInstance(), other.maxIopsPerDbInstance()) && Objects.equals(this.minIopsPerGib(), other.minIopsPerGib()) && Objects.equals(this.maxIopsPerGib(), other.maxIopsPerGib()) && Objects.equals(this.availableProcessorFeatures(), other.availableProcessorFeatures()) && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && Objects.equals(this.supportsStorageAutoscaling(), other.supportsStorageAutoscaling());
    }

    public String toString() {
        return ToString.builder((String)"OrderableDBInstanceOption").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("LicenseModel", (Object)this.licenseModel()).add("AvailabilityZones", this.availabilityZones()).add("MultiAZCapable", (Object)this.multiAZCapable()).add("ReadReplicaCapable", (Object)this.readReplicaCapable()).add("Vpc", (Object)this.vpc()).add("SupportsStorageEncryption", (Object)this.supportsStorageEncryption()).add("StorageType", (Object)this.storageType()).add("SupportsIops", (Object)this.supportsIops()).add("SupportsEnhancedMonitoring", (Object)this.supportsEnhancedMonitoring()).add("SupportsIAMDatabaseAuthentication", (Object)this.supportsIAMDatabaseAuthentication()).add("SupportsPerformanceInsights", (Object)this.supportsPerformanceInsights()).add("MinStorageSize", (Object)this.minStorageSize()).add("MaxStorageSize", (Object)this.maxStorageSize()).add("MinIopsPerDbInstance", (Object)this.minIopsPerDbInstance()).add("MaxIopsPerDbInstance", (Object)this.maxIopsPerDbInstance()).add("MinIopsPerGib", (Object)this.minIopsPerGib()).add("MaxIopsPerGib", (Object)this.maxIopsPerGib()).add("AvailableProcessorFeatures", this.availableProcessorFeatures()).add("SupportedEngineModes", this.supportedEngineModes()).add("SupportsStorageAutoscaling", (Object)this.supportsStorageAutoscaling()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "MultiAZCapable": {
                return Optional.ofNullable(clazz.cast(this.multiAZCapable()));
            }
            case "ReadReplicaCapable": {
                return Optional.ofNullable(clazz.cast(this.readReplicaCapable()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "SupportsStorageEncryption": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageEncryption()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "SupportsIops": {
                return Optional.ofNullable(clazz.cast(this.supportsIops()));
            }
            case "SupportsEnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.supportsEnhancedMonitoring()));
            }
            case "SupportsIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.supportsIAMDatabaseAuthentication()));
            }
            case "SupportsPerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.supportsPerformanceInsights()));
            }
            case "MinStorageSize": {
                return Optional.ofNullable(clazz.cast(this.minStorageSize()));
            }
            case "MaxStorageSize": {
                return Optional.ofNullable(clazz.cast(this.maxStorageSize()));
            }
            case "MinIopsPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.minIopsPerDbInstance()));
            }
            case "MaxIopsPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.maxIopsPerDbInstance()));
            }
            case "MinIopsPerGib": {
                return Optional.ofNullable(clazz.cast(this.minIopsPerGib()));
            }
            case "MaxIopsPerGib": {
                return Optional.ofNullable(clazz.cast(this.maxIopsPerGib()));
            }
            case "AvailableProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.availableProcessorFeatures()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportsStorageAutoscaling": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageAutoscaling()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderableDBInstanceOption, T> g) {
        return obj -> g.apply((OrderableDBInstanceOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbInstanceClass;
        private String licenseModel;
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiAZCapable;
        private Boolean readReplicaCapable;
        private Boolean vpc;
        private Boolean supportsStorageEncryption;
        private String storageType;
        private Boolean supportsIops;
        private Boolean supportsEnhancedMonitoring;
        private Boolean supportsIAMDatabaseAuthentication;
        private Boolean supportsPerformanceInsights;
        private Integer minStorageSize;
        private Integer maxStorageSize;
        private Integer minIopsPerDbInstance;
        private Integer maxIopsPerDbInstance;
        private Double minIopsPerGib;
        private Double maxIopsPerGib;
        private List<AvailableProcessorFeature> availableProcessorFeatures = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsStorageAutoscaling;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableDBInstanceOption model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbInstanceClass(model.dbInstanceClass);
            this.licenseModel(model.licenseModel);
            this.availabilityZones(model.availabilityZones);
            this.multiAZCapable(model.multiAZCapable);
            this.readReplicaCapable(model.readReplicaCapable);
            this.vpc(model.vpc);
            this.supportsStorageEncryption(model.supportsStorageEncryption);
            this.storageType(model.storageType);
            this.supportsIops(model.supportsIops);
            this.supportsEnhancedMonitoring(model.supportsEnhancedMonitoring);
            this.supportsIAMDatabaseAuthentication(model.supportsIAMDatabaseAuthentication);
            this.supportsPerformanceInsights(model.supportsPerformanceInsights);
            this.minStorageSize(model.minStorageSize);
            this.maxStorageSize(model.maxStorageSize);
            this.minIopsPerDbInstance(model.minIopsPerDbInstance);
            this.maxIopsPerDbInstance(model.maxIopsPerDbInstance);
            this.minIopsPerGib(model.minIopsPerGib);
            this.maxIopsPerGib(model.maxIopsPerGib);
            this.availableProcessorFeatures(model.availableProcessorFeatures);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportsStorageAutoscaling(model.supportsStorageAutoscaling);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        public final Boolean getMultiAZCapable() {
            return this.multiAZCapable;
        }

        @Override
        public final Builder multiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
            return this;
        }

        public final void setMultiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
        }

        public final Boolean getReadReplicaCapable() {
            return this.readReplicaCapable;
        }

        @Override
        public final Builder readReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
            return this;
        }

        public final void setReadReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
        }

        public final Boolean getVpc() {
            return this.vpc;
        }

        @Override
        public final Builder vpc(Boolean vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(Boolean vpc) {
            this.vpc = vpc;
        }

        public final Boolean getSupportsStorageEncryption() {
            return this.supportsStorageEncryption;
        }

        @Override
        public final Builder supportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
            return this;
        }

        public final void setSupportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Boolean getSupportsIops() {
            return this.supportsIops;
        }

        @Override
        public final Builder supportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
            return this;
        }

        public final void setSupportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
        }

        public final Boolean getSupportsEnhancedMonitoring() {
            return this.supportsEnhancedMonitoring;
        }

        @Override
        public final Builder supportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
            return this;
        }

        public final void setSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
        }

        public final Boolean getSupportsIAMDatabaseAuthentication() {
            return this.supportsIAMDatabaseAuthentication;
        }

        @Override
        public final Builder supportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
            return this;
        }

        public final void setSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
        }

        public final Boolean getSupportsPerformanceInsights() {
            return this.supportsPerformanceInsights;
        }

        @Override
        public final Builder supportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
            return this;
        }

        public final void setSupportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
        }

        public final Integer getMinStorageSize() {
            return this.minStorageSize;
        }

        @Override
        public final Builder minStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
            return this;
        }

        public final void setMinStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
        }

        public final Integer getMaxStorageSize() {
            return this.maxStorageSize;
        }

        @Override
        public final Builder maxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
            return this;
        }

        public final void setMaxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
        }

        public final Integer getMinIopsPerDbInstance() {
            return this.minIopsPerDbInstance;
        }

        @Override
        public final Builder minIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
            return this;
        }

        public final void setMinIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
        }

        public final Integer getMaxIopsPerDbInstance() {
            return this.maxIopsPerDbInstance;
        }

        @Override
        public final Builder maxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
            return this;
        }

        public final void setMaxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
        }

        public final Double getMinIopsPerGib() {
            return this.minIopsPerGib;
        }

        @Override
        public final Builder minIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
            return this;
        }

        public final void setMinIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
        }

        public final Double getMaxIopsPerGib() {
            return this.maxIopsPerGib;
        }

        @Override
        public final Builder maxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
            return this;
        }

        public final void setMaxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
        }

        public final Collection<AvailableProcessorFeature.Builder> getAvailableProcessorFeatures() {
            return this.availableProcessorFeatures != null ? (Collection)this.availableProcessorFeatures.stream().map(AvailableProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availableProcessorFeatures(Collection<AvailableProcessorFeature> availableProcessorFeatures) {
            this.availableProcessorFeatures = AvailableProcessorFeatureListCopier.copy(availableProcessorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProcessorFeatures(AvailableProcessorFeature ... availableProcessorFeatures) {
            this.availableProcessorFeatures(Arrays.asList(availableProcessorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... availableProcessorFeatures) {
            this.availableProcessorFeatures(Stream.of(availableProcessorFeatures).map(c -> (AvailableProcessorFeature)((AvailableProcessorFeature.Builder)AvailableProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailableProcessorFeatures(Collection<AvailableProcessorFeature.BuilderImpl> availableProcessorFeatures) {
            this.availableProcessorFeatures = AvailableProcessorFeatureListCopier.copyFromBuilder(availableProcessorFeatures);
        }

        public final Collection<String> getSupportedEngineModes() {
            return this.supportedEngineModes;
        }

        @Override
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        public final Boolean getSupportsStorageAutoscaling() {
            return this.supportsStorageAutoscaling;
        }

        @Override
        public final Builder supportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
            return this;
        }

        public final void setSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
        }

        public OrderableDBInstanceOption build() {
            return new OrderableDBInstanceOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderableDBInstanceOption> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder licenseModel(String var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder multiAZCapable(Boolean var1);

        public Builder readReplicaCapable(Boolean var1);

        public Builder vpc(Boolean var1);

        public Builder supportsStorageEncryption(Boolean var1);

        public Builder storageType(String var1);

        public Builder supportsIops(Boolean var1);

        public Builder supportsEnhancedMonitoring(Boolean var1);

        public Builder supportsIAMDatabaseAuthentication(Boolean var1);

        public Builder supportsPerformanceInsights(Boolean var1);

        public Builder minStorageSize(Integer var1);

        public Builder maxStorageSize(Integer var1);

        public Builder minIopsPerDbInstance(Integer var1);

        public Builder maxIopsPerDbInstance(Integer var1);

        public Builder minIopsPerGib(Double var1);

        public Builder maxIopsPerGib(Double var1);

        public Builder availableProcessorFeatures(Collection<AvailableProcessorFeature> var1);

        public Builder availableProcessorFeatures(AvailableProcessorFeature ... var1);

        public Builder availableProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportsStorageAutoscaling(Boolean var1);
    }
}

