/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse;

public class DescribeDBSnapshotTenantDatabasesPublisher
implements SdkPublisher<DescribeDbSnapshotTenantDatabasesResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbSnapshotTenantDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSnapshotTenantDatabasesPublisher(RdsAsyncClient client, DescribeDbSnapshotTenantDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSnapshotTenantDatabasesPublisher(RdsAsyncClient client, DescribeDbSnapshotTenantDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbSnapshotTenantDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbSnapshotTenantDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases() {
        Function<DescribeDbSnapshotTenantDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshotTenantDatabases() != null) {
                return response.dbSnapshotTenantDatabases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbSnapshotTenantDatabasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbSnapshotTenantDatabasesResponseFetcher
    implements AsyncPageFetcher<DescribeDbSnapshotTenantDatabasesResponse> {
        private DescribeDbSnapshotTenantDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSnapshotTenantDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbSnapshotTenantDatabasesResponse> nextPage(DescribeDbSnapshotTenantDatabasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotTenantDatabasesPublisher.this.client.describeDBSnapshotTenantDatabases(DescribeDBSnapshotTenantDatabasesPublisher.this.firstRequest);
            }
            return DescribeDBSnapshotTenantDatabasesPublisher.this.client.describeDBSnapshotTenantDatabases((DescribeDbSnapshotTenantDatabasesRequest)((Object)DescribeDBSnapshotTenantDatabasesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

