/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDbInstanceAutomatedBackupsReplicationRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, StartDbInstanceAutomatedBackupsReplicationRequest> {
    private static final SdkField<String> SOURCE_DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBInstanceArn").getter(StartDbInstanceAutomatedBackupsReplicationRequest.getter(StartDbInstanceAutomatedBackupsReplicationRequest::sourceDBInstanceArn)).setter(StartDbInstanceAutomatedBackupsReplicationRequest.setter(Builder::sourceDBInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceArn").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(StartDbInstanceAutomatedBackupsReplicationRequest.getter(StartDbInstanceAutomatedBackupsReplicationRequest::backupRetentionPeriod)).setter(StartDbInstanceAutomatedBackupsReplicationRequest.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StartDbInstanceAutomatedBackupsReplicationRequest.getter(StartDbInstanceAutomatedBackupsReplicationRequest::kmsKeyId)).setter(StartDbInstanceAutomatedBackupsReplicationRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(StartDbInstanceAutomatedBackupsReplicationRequest.getter(StartDbInstanceAutomatedBackupsReplicationRequest::preSignedUrl)).setter(StartDbInstanceAutomatedBackupsReplicationRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(StartDbInstanceAutomatedBackupsReplicationRequest.getter(StartDbInstanceAutomatedBackupsReplicationRequest::sourceRegion)).setter(StartDbInstanceAutomatedBackupsReplicationRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_INSTANCE_ARN_FIELD, BACKUP_RETENTION_PERIOD_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, SOURCE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDbInstanceAutomatedBackupsReplicationRequest.memberNameToFieldInitializer();
    private final String sourceDBInstanceArn;
    private final Integer backupRetentionPeriod;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final String sourceRegion;

    private StartDbInstanceAutomatedBackupsReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBInstanceArn = builder.sourceDBInstanceArn;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.sourceRegion = builder.sourceRegion;
    }

    public final String sourceDBInstanceArn() {
        return this.sourceDBInstanceArn;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String preSignedUrl() {
        return this.preSignedUrl;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDbInstanceAutomatedBackupsReplicationRequest)) {
            return false;
        }
        StartDbInstanceAutomatedBackupsReplicationRequest other = (StartDbInstanceAutomatedBackupsReplicationRequest)((Object)obj);
        return Objects.equals(this.sourceDBInstanceArn(), other.sourceDBInstanceArn()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"StartDbInstanceAutomatedBackupsReplicationRequest").add("SourceDBInstanceArn", (Object)this.sourceDBInstanceArn()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceDBInstanceArn()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceDBInstanceArn", SOURCE_DB_INSTANCE_ARN_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDbInstanceAutomatedBackupsReplicationRequest, T> g) {
        return obj -> g.apply((StartDbInstanceAutomatedBackupsReplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBInstanceArn;
        private Integer backupRetentionPeriod;
        private String kmsKeyId;
        private String preSignedUrl;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDbInstanceAutomatedBackupsReplicationRequest model) {
            super(model);
            this.sourceDBInstanceArn(model.sourceDBInstanceArn);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceDBInstanceArn() {
            return this.sourceDBInstanceArn;
        }

        public final void setSourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
        }

        @Override
        public final Builder sourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDbInstanceAutomatedBackupsReplicationRequest build() {
            return new StartDbInstanceAutomatedBackupsReplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDbInstanceAutomatedBackupsReplicationRequest> {
        public Builder sourceDBInstanceArn(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

