/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTenantDatabaseRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyTenantDatabaseRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::dbInstanceIdentifier)).setter(ModifyTenantDatabaseRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDBName").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::tenantDBName)).setter(ModifyTenantDatabaseRequest.setter(Builder::tenantDBName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::masterUserPassword)).setter(ModifyTenantDatabaseRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> NEW_TENANT_DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewTenantDBName").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::newTenantDBName)).setter(ModifyTenantDatabaseRequest.setter(Builder::newTenantDBName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewTenantDBName").build()}).build();
    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::manageMasterUserPassword)).setter(ModifyTenantDatabaseRequest.setter(Builder::manageMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build()}).build();
    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RotateMasterUserPassword").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::rotateMasterUserPassword)).setter(ModifyTenantDatabaseRequest.setter(Builder::rotateMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotateMasterUserPassword").build()}).build();
    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserSecretKmsKeyId").getter(ModifyTenantDatabaseRequest.getter(ModifyTenantDatabaseRequest::masterUserSecretKmsKeyId)).setter(ModifyTenantDatabaseRequest.setter(Builder::masterUserSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, TENANT_DB_NAME_FIELD, MASTER_USER_PASSWORD_FIELD, NEW_TENANT_DB_NAME_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyTenantDatabaseRequest.memberNameToFieldInitializer();
    private final String dbInstanceIdentifier;
    private final String tenantDBName;
    private final String masterUserPassword;
    private final String newTenantDBName;
    private final Boolean manageMasterUserPassword;
    private final Boolean rotateMasterUserPassword;
    private final String masterUserSecretKmsKeyId;

    private ModifyTenantDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.masterUserPassword = builder.masterUserPassword;
        this.newTenantDBName = builder.newTenantDBName;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String tenantDBName() {
        return this.tenantDBName;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String newTenantDBName() {
        return this.newTenantDBName;
    }

    public final Boolean manageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public final Boolean rotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    public final String masterUserSecretKmsKeyId() {
        return this.masterUserSecretKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserSecretKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTenantDatabaseRequest)) {
            return false;
        }
        ModifyTenantDatabaseRequest other = (ModifyTenantDatabaseRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.tenantDBName(), other.tenantDBName()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.newTenantDBName(), other.newTenantDBName()) && Objects.equals(this.manageMasterUserPassword(), other.manageMasterUserPassword()) && Objects.equals(this.rotateMasterUserPassword(), other.rotateMasterUserPassword()) && Objects.equals(this.masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTenantDatabaseRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("TenantDBName", (Object)this.tenantDBName()).add("MasterUserPassword", (Object)(this.masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NewTenantDBName", (Object)this.newTenantDBName()).add("ManageMasterUserPassword", (Object)this.manageMasterUserPassword()).add("RotateMasterUserPassword", (Object)this.rotateMasterUserPassword()).add("MasterUserSecretKmsKeyId", (Object)this.masterUserSecretKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "TenantDBName": {
                return Optional.ofNullable(clazz.cast(this.tenantDBName()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "NewTenantDBName": {
                return Optional.ofNullable(clazz.cast(this.newTenantDBName()));
            }
            case "ManageMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.manageMasterUserPassword()));
            }
            case "RotateMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.rotateMasterUserPassword()));
            }
            case "MasterUserSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.masterUserSecretKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("NewTenantDBName", NEW_TENANT_DB_NAME_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("RotateMasterUserPassword", ROTATE_MASTER_USER_PASSWORD_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTenantDatabaseRequest, T> g) {
        return obj -> g.apply((ModifyTenantDatabaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String tenantDBName;
        private String masterUserPassword;
        private String newTenantDBName;
        private Boolean manageMasterUserPassword;
        private Boolean rotateMasterUserPassword;
        private String masterUserSecretKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTenantDatabaseRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.tenantDBName(model.tenantDBName);
            this.masterUserPassword(model.masterUserPassword);
            this.newTenantDBName(model.newTenantDBName);
            this.manageMasterUserPassword(model.manageMasterUserPassword);
            this.rotateMasterUserPassword(model.rotateMasterUserPassword);
            this.masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return this.tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getNewTenantDBName() {
            return this.newTenantDBName;
        }

        public final void setNewTenantDBName(String newTenantDBName) {
            this.newTenantDBName = newTenantDBName;
        }

        @Override
        public final Builder newTenantDBName(String newTenantDBName) {
            this.newTenantDBName = newTenantDBName;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final Boolean getRotateMasterUserPassword() {
            return this.rotateMasterUserPassword;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return this.masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTenantDatabaseRequest build() {
            return new ModifyTenantDatabaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTenantDatabaseRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder tenantDBName(String var1);

        public Builder masterUserPassword(String var1);

        public Builder newTenantDBName(String var1);

        public Builder manageMasterUserPassword(Boolean var1);

        public Builder rotateMasterUserPassword(Boolean var1);

        public Builder masterUserSecretKmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

