/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbProxyRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeleteDbProxyRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(DeleteDbProxyRequest.getter(DeleteDbProxyRequest::dbProxyName)).setter(DeleteDbProxyRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBProxyName", DB_PROXY_NAME_FIELD);
        }
    });
    private final String dbProxyName;

    private DeleteDbProxyRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbProxyRequest)) {
            return false;
        }
        DeleteDbProxyRequest other = (DeleteDbProxyRequest)((Object)obj);
        return Objects.equals(this.dbProxyName(), other.dbProxyName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDbProxyRequest").add("DBProxyName", (Object)this.dbProxyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbProxyRequest, T> g) {
        return obj -> g.apply((DeleteDbProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbProxyRequest model) {
            super(model);
            this.dbProxyName(model.dbProxyName);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbProxyRequest build() {
            return new DeleteDbProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbProxyRequest> {
        public Builder dbProxyName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

