/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DBParameterGroupListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbParameterGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbParameterGroupsResponse.getter(DescribeDbParameterGroupsResponse::marker)).setter(DescribeDbParameterGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBParameterGroup>> DB_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBParameterGroups").getter(DescribeDbParameterGroupsResponse.getter(DescribeDbParameterGroupsResponse::dbParameterGroups)).setter(DescribeDbParameterGroupsResponse.setter(Builder::dbParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroups").build(), ListTrait.builder().memberLocationName("DBParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_PARAMETER_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Marker", MARKER_FIELD);
            this.put("DBParameterGroups", DB_PARAMETER_GROUPS_FIELD);
        }
    });
    private final String marker;
    private final List<DBParameterGroup> dbParameterGroups;

    private DescribeDbParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbParameterGroups = builder.dbParameterGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbParameterGroups() {
        return this.dbParameterGroups != null && !(this.dbParameterGroups instanceof SdkAutoConstructList);
    }

    public final List<DBParameterGroup> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbParameterGroups() ? this.dbParameterGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbParameterGroupsResponse)) {
            return false;
        }
        DescribeDbParameterGroupsResponse other = (DescribeDbParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbParameterGroups() == other.hasDbParameterGroups() && Objects.equals(this.dbParameterGroups(), other.dbParameterGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBParameterGroups", this.hasDbParameterGroups() ? this.dbParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBParameterGroup> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbParameterGroups(model.dbParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBParameterGroup.Builder> getDbParameterGroups() {
            List<DBParameterGroup.Builder> result = DBParameterGroupListCopier.copyToBuilder(this.dbParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbParameterGroups(Collection<DBParameterGroup.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copyFromBuilder(dbParameterGroups);
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroup ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... dbParameterGroups) {
            this.dbParameterGroups(Stream.of(dbParameterGroups).map(c -> (DBParameterGroup)((DBParameterGroup.Builder)DBParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbParameterGroupsResponse build() {
            return new DescribeDbParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbParameterGroups(Collection<DBParameterGroup> var1);

        public Builder dbParameterGroups(DBParameterGroup ... var1);

        public Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... var1);
    }
}

