/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBProxyTargetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBProxyTargetGroup> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::dbProxyName)).setter(DBProxyTargetGroup.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupName").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::targetGroupName)).setter(DBProxyTargetGroup.setter(Builder::targetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()}).build();
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupArn").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::targetGroupArn)).setter(DBProxyTargetGroup.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::isDefault)).setter(DBProxyTargetGroup.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::status)).setter(DBProxyTargetGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ConnectionPoolConfigurationInfo> CONNECTION_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionPoolConfig").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::connectionPoolConfig)).setter(DBProxyTargetGroup.setter(Builder::connectionPoolConfig)).constructor(ConnectionPoolConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPoolConfig").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::createdDate)).setter(DBProxyTargetGroup.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedDate").getter(DBProxyTargetGroup.getter(DBProxyTargetGroup::updatedDate)).setter(DBProxyTargetGroup.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, TARGET_GROUP_NAME_FIELD, TARGET_GROUP_ARN_FIELD, IS_DEFAULT_FIELD, STATUS_FIELD, CONNECTION_POOL_CONFIG_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBProxyName", DB_PROXY_NAME_FIELD);
            this.put("TargetGroupName", TARGET_GROUP_NAME_FIELD);
            this.put("TargetGroupArn", TARGET_GROUP_ARN_FIELD);
            this.put("IsDefault", IS_DEFAULT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ConnectionPoolConfig", CONNECTION_POOL_CONFIG_FIELD);
            this.put("CreatedDate", CREATED_DATE_FIELD);
            this.put("UpdatedDate", UPDATED_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dbProxyName;
    private final String targetGroupName;
    private final String targetGroupArn;
    private final Boolean isDefault;
    private final String status;
    private final ConnectionPoolConfigurationInfo connectionPoolConfig;
    private final Instant createdDate;
    private final Instant updatedDate;

    private DBProxyTargetGroup(BuilderImpl builder) {
        this.dbProxyName = builder.dbProxyName;
        this.targetGroupName = builder.targetGroupName;
        this.targetGroupArn = builder.targetGroupArn;
        this.isDefault = builder.isDefault;
        this.status = builder.status;
        this.connectionPoolConfig = builder.connectionPoolConfig;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final String targetGroupName() {
        return this.targetGroupName;
    }

    public final String targetGroupArn() {
        return this.targetGroupArn;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String status() {
        return this.status;
    }

    public final ConnectionPoolConfigurationInfo connectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant updatedDate() {
        return this.updatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxyTargetGroup)) {
            return false;
        }
        DBProxyTargetGroup other = (DBProxyTargetGroup)obj;
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.targetGroupName(), other.targetGroupName()) && Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.connectionPoolConfig(), other.connectionPoolConfig()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DBProxyTargetGroup").add("DBProxyName", (Object)this.dbProxyName()).add("TargetGroupName", (Object)this.targetGroupName()).add("TargetGroupArn", (Object)this.targetGroupArn()).add("IsDefault", (Object)this.isDefault()).add("Status", (Object)this.status()).add("ConnectionPoolConfig", (Object)this.connectionPoolConfig()).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "TargetGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetGroupName()));
            }
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ConnectionPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.connectionPoolConfig()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "UpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DBProxyTargetGroup, T> g) {
        return obj -> g.apply((DBProxyTargetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String targetGroupName;
        private String targetGroupArn;
        private Boolean isDefault;
        private String status;
        private ConnectionPoolConfigurationInfo connectionPoolConfig;
        private Instant createdDate;
        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxyTargetGroup model) {
            this.dbProxyName(model.dbProxyName);
            this.targetGroupName(model.targetGroupName);
            this.targetGroupArn(model.targetGroupArn);
            this.isDefault(model.isDefault);
            this.status(model.status);
            this.connectionPoolConfig(model.connectionPoolConfig);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ConnectionPoolConfigurationInfo.Builder getConnectionPoolConfig() {
            return this.connectionPoolConfig != null ? this.connectionPoolConfig.toBuilder() : null;
        }

        public final void setConnectionPoolConfig(ConnectionPoolConfigurationInfo.BuilderImpl connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig != null ? connectionPoolConfig.build() : null;
        }

        @Override
        public final Builder connectionPoolConfig(ConnectionPoolConfigurationInfo connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public DBProxyTargetGroup build() {
            return new DBProxyTargetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBProxyTargetGroup> {
        public Builder dbProxyName(String var1);

        public Builder targetGroupName(String var1);

        public Builder targetGroupArn(String var1);

        public Builder isDefault(Boolean var1);

        public Builder status(String var1);

        public Builder connectionPoolConfig(ConnectionPoolConfigurationInfo var1);

        default public Builder connectionPoolConfig(Consumer<ConnectionPoolConfigurationInfo.Builder> connectionPoolConfig) {
            return this.connectionPoolConfig((ConnectionPoolConfigurationInfo)((ConnectionPoolConfigurationInfo.Builder)ConnectionPoolConfigurationInfo.builder().applyMutation(connectionPoolConfig)).build());
        }

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);
    }
}

