/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse;

public class DescribeDBClusterParameterGroupsIterable
implements SdkIterable<DescribeDbClusterParameterGroupsResponse> {
    private final RdsClient client;
    private final DescribeDbClusterParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterParameterGroupsIterable(RdsClient client, DescribeDbClusterParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClusterParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDbClusterParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterParameterGroup> dbClusterParameterGroups() {
        Function<DescribeDbClusterParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterParameterGroups() != null) {
                return response.dbClusterParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterParameterGroupsResponse> {
        private DescribeDbClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterParameterGroupsResponse nextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterParameterGroupsIterable.this.client.describeDBClusterParameterGroups(DescribeDBClusterParameterGroupsIterable.this.firstRequest);
            }
            return DescribeDBClusterParameterGroupsIterable.this.client.describeDBClusterParameterGroups((DescribeDbClusterParameterGroupsRequest)((Object)DescribeDBClusterParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

