/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ActivityStreamMode;
import software.amazon.awssdk.services.rds.model.ActivityStreamStatus;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues;
import software.amazon.awssdk.services.rds.model.DBClusterMember;
import software.amazon.awssdk.services.rds.model.DBClusterMemberListCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupMembershipsCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus;
import software.amazon.awssdk.services.rds.model.DBClusterRole;
import software.amazon.awssdk.services.rds.model.DBClusterRolesCopier;
import software.amazon.awssdk.services.rds.model.DomainMembership;
import software.amazon.awssdk.services.rds.model.DomainMembershipListCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo;
import software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfigurationInfo;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.WriteForwardingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBCluster> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(DBCluster.getter(DBCluster::allocatedStorage)).setter(DBCluster.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(DBCluster.getter(DBCluster::availabilityZones)).setter(DBCluster.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(DBCluster.getter(DBCluster::backupRetentionPeriod)).setter(DBCluster.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(DBCluster.getter(DBCluster::characterSetName)).setter(DBCluster.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DBCluster.getter(DBCluster::databaseName)).setter(DBCluster.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DBCluster.getter(DBCluster::dbClusterIdentifier)).setter(DBCluster.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroup").getter(DBCluster.getter(DBCluster::dbClusterParameterGroup)).setter(DBCluster.setter(Builder::dbClusterParameterGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroup").getter(DBCluster.getter(DBCluster::dbSubnetGroup)).setter(DBCluster.setter(Builder::dbSubnetGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBCluster.getter(DBCluster::status)).setter(DBCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> AUTOMATIC_RESTART_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AutomaticRestartTime").getter(DBCluster.getter(DBCluster::automaticRestartTime)).setter(DBCluster.setter(Builder::automaticRestartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticRestartTime").build()}).build();
    private static final SdkField<String> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PercentProgress").getter(DBCluster.getter(DBCluster::percentProgress)).setter(DBCluster.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestRestorableTime").getter(DBCluster.getter(DBCluster::earliestRestorableTime)).setter(DBCluster.setter(Builder::earliestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableTime").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DBCluster.getter(DBCluster::endpoint)).setter(DBCluster.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReaderEndpoint").getter(DBCluster.getter(DBCluster::readerEndpoint)).setter(DBCluster.setter(Builder::readerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()}).build();
    private static final SdkField<List<String>> CUSTOM_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomEndpoints").getter(DBCluster.getter(DBCluster::customEndpoints)).setter(DBCluster.setter(Builder::customEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(DBCluster.getter(DBCluster::multiAZ)).setter(DBCluster.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBCluster.getter(DBCluster::engine)).setter(DBCluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBCluster.getter(DBCluster::engineVersion)).setter(DBCluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestRestorableTime").getter(DBCluster.getter(DBCluster::latestRestorableTime)).setter(DBCluster.setter(Builder::latestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DBCluster.getter(DBCluster::port)).setter(DBCluster.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBCluster.getter(DBCluster::masterUsername)).setter(DBCluster.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<List<DBClusterOptionGroupStatus>> DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterOptionGroupMemberships").getter(DBCluster.getter(DBCluster::dbClusterOptionGroupMemberships)).setter(DBCluster.setter(Builder::dbClusterOptionGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterOptionGroupMemberships").build(), ListTrait.builder().memberLocationName("DBClusterOptionGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterOptionGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterOptionGroup").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(DBCluster.getter(DBCluster::preferredBackupWindow)).setter(DBCluster.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(DBCluster.getter(DBCluster::preferredMaintenanceWindow)).setter(DBCluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSourceIdentifier").getter(DBCluster.getter(DBCluster::replicationSourceIdentifier)).setter(DBCluster.setter(Builder::replicationSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier").build()}).build();
    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadReplicaIdentifiers").getter(DBCluster.getter(DBCluster::readReplicaIdentifiers)).setter(DBCluster.setter(Builder::readReplicaIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(), ListTrait.builder().memberLocationName("ReadReplicaIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifier").build()}).build()).build()}).build();
    private static final SdkField<List<DBClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterMembers").getter(DBCluster.getter(DBCluster::dbClusterMembers)).setter(DBCluster.setter(Builder::dbClusterMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMembers").build(), ListTrait.builder().memberLocationName("DBClusterMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMember").build()}).build()).build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(DBCluster.getter(DBCluster::vpcSecurityGroups)).setter(DBCluster.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMembership").build()}).build()).build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(DBCluster.getter(DBCluster::hostedZoneId)).setter(DBCluster.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(DBCluster.getter(DBCluster::storageEncrypted)).setter(DBCluster.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DBCluster.getter(DBCluster::kmsKeyId)).setter(DBCluster.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterResourceId").getter(DBCluster.getter(DBCluster::dbClusterResourceId)).setter(DBCluster.setter(Builder::dbClusterResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterArn").getter(DBCluster.getter(DBCluster::dbClusterArn)).setter(DBCluster.setter(Builder::dbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()}).build();
    private static final SdkField<List<DBClusterRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoles").getter(DBCluster.getter(DBCluster::associatedRoles)).setter(DBCluster.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(), ListTrait.builder().memberLocationName("DBClusterRole").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterRole").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IAMDatabaseAuthenticationEnabled").getter(DBCluster.getter(DBCluster::iamDatabaseAuthenticationEnabled)).setter(DBCluster.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<String> CLONE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloneGroupId").getter(DBCluster.getter(DBCluster::cloneGroupId)).setter(DBCluster.setter(Builder::cloneGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloneGroupId").build()}).build();
    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClusterCreateTime").getter(DBCluster.getter(DBCluster::clusterCreateTime)).setter(DBCluster.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<Instant> EARLIEST_BACKTRACK_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestBacktrackTime").getter(DBCluster.getter(DBCluster::earliestBacktrackTime)).setter(DBCluster.setter(Builder::earliestBacktrackTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestBacktrackTime").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(DBCluster.getter(DBCluster::backtrackWindow)).setter(DBCluster.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<Long> BACKTRACK_CONSUMED_CHANGE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackConsumedChangeRecords").getter(DBCluster.getter(DBCluster::backtrackConsumedChangeRecords)).setter(DBCluster.setter(Builder::backtrackConsumedChangeRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackConsumedChangeRecords").build()}).build();
    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledCloudwatchLogsExports").getter(DBCluster.getter(DBCluster::enabledCloudwatchLogsExports)).setter(DBCluster.setter(Builder::enabledCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(DBCluster.getter(DBCluster::capacity)).setter(DBCluster.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(DBCluster.getter(DBCluster::engineMode)).setter(DBCluster.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<ScalingConfigurationInfo> SCALING_CONFIGURATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfigurationInfo").getter(DBCluster.getter(DBCluster::scalingConfigurationInfo)).setter(DBCluster.setter(Builder::scalingConfigurationInfo)).constructor(ScalingConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfigurationInfo").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(DBCluster.getter(DBCluster::deletionProtection)).setter(DBCluster.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> HTTP_ENDPOINT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HttpEndpointEnabled").getter(DBCluster.getter(DBCluster::httpEndpointEnabled)).setter(DBCluster.setter(Builder::httpEndpointEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointEnabled").build()}).build();
    private static final SdkField<String> ACTIVITY_STREAM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStreamMode").getter(DBCluster.getter(DBCluster::activityStreamModeAsString)).setter(DBCluster.setter(Builder::activityStreamMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamMode").build()}).build();
    private static final SdkField<String> ACTIVITY_STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStreamStatus").getter(DBCluster.getter(DBCluster::activityStreamStatusAsString)).setter(DBCluster.setter(Builder::activityStreamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamStatus").build()}).build();
    private static final SdkField<String> ACTIVITY_STREAM_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStreamKmsKeyId").getter(DBCluster.getter(DBCluster::activityStreamKmsKeyId)).setter(DBCluster.setter(Builder::activityStreamKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamKmsKeyId").build()}).build();
    private static final SdkField<String> ACTIVITY_STREAM_KINESIS_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStreamKinesisStreamName").getter(DBCluster.getter(DBCluster::activityStreamKinesisStreamName)).setter(DBCluster.setter(Builder::activityStreamKinesisStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamKinesisStreamName").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(DBCluster.getter(DBCluster::copyTagsToSnapshot)).setter(DBCluster.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Boolean> CROSS_ACCOUNT_CLONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrossAccountClone").getter(DBCluster.getter(DBCluster::crossAccountClone)).setter(DBCluster.setter(Builder::crossAccountClone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountClone").build()}).build();
    private static final SdkField<List<DomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainMemberships").getter(DBCluster.getter(DBCluster::domainMemberships)).setter(DBCluster.setter(Builder::domainMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(), ListTrait.builder().memberLocationName("DomainMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMembership").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBCluster.getter(DBCluster::tagList)).setter(DBCluster.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> GLOBAL_WRITE_FORWARDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalWriteForwardingStatus").getter(DBCluster.getter(DBCluster::globalWriteForwardingStatusAsString)).setter(DBCluster.setter(Builder::globalWriteForwardingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalWriteForwardingStatus").build()}).build();
    private static final SdkField<Boolean> GLOBAL_WRITE_FORWARDING_REQUESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GlobalWriteForwardingRequested").getter(DBCluster.getter(DBCluster::globalWriteForwardingRequested)).setter(DBCluster.setter(Builder::globalWriteForwardingRequested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalWriteForwardingRequested").build()}).build();
    private static final SdkField<ClusterPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(DBCluster.getter(DBCluster::pendingModifiedValues)).setter(DBCluster.setter(Builder::pendingModifiedValues)).constructor(ClusterPendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterInstanceClass").getter(DBCluster.getter(DBCluster::dbClusterInstanceClass)).setter(DBCluster.setter(Builder::dbClusterInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DBCluster.getter(DBCluster::storageType)).setter(DBCluster.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(DBCluster.getter(DBCluster::iops)).setter(DBCluster.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(DBCluster.getter(DBCluster::publiclyAccessible)).setter(DBCluster.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(DBCluster.getter(DBCluster::autoMinorVersionUpgrade)).setter(DBCluster.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(DBCluster.getter(DBCluster::monitoringInterval)).setter(DBCluster.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(DBCluster.getter(DBCluster::monitoringRoleArn)).setter(DBCluster.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<Boolean> PERFORMANCE_INSIGHTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformanceInsightsEnabled").getter(DBCluster.getter(DBCluster::performanceInsightsEnabled)).setter(DBCluster.setter(Builder::performanceInsightsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsEnabled").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(DBCluster.getter(DBCluster::performanceInsightsKMSKeyId)).setter(DBCluster.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(DBCluster.getter(DBCluster::performanceInsightsRetentionPeriod)).setter(DBCluster.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<ServerlessV2ScalingConfigurationInfo> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2ScalingConfiguration").getter(DBCluster.getter(DBCluster::serverlessV2ScalingConfiguration)).setter(DBCluster.setter(Builder::serverlessV2ScalingConfiguration)).constructor(ServerlessV2ScalingConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(DBCluster.getter(DBCluster::networkType)).setter(DBCluster.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSystemId").getter(DBCluster.getter(DBCluster::dbSystemId)).setter(DBCluster.setter(Builder::dbSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSystemId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD, AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD, STATUS_FIELD, AUTOMATIC_RESTART_TIME_FIELD, PERCENT_PROGRESS_FIELD, EARLIEST_RESTORABLE_TIME_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, CUSTOM_ENDPOINTS_FIELD, MULTI_AZ_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, LATEST_RESTORABLE_TIME_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SOURCE_IDENTIFIER_FIELD, READ_REPLICA_IDENTIFIERS_FIELD, DB_CLUSTER_MEMBERS_FIELD, VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, DB_CLUSTER_ARN_FIELD, ASSOCIATED_ROLES_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, CLONE_GROUP_ID_FIELD, CLUSTER_CREATE_TIME_FIELD, EARLIEST_BACKTRACK_TIME_FIELD, BACKTRACK_WINDOW_FIELD, BACKTRACK_CONSUMED_CHANGE_RECORDS_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, CAPACITY_FIELD, ENGINE_MODE_FIELD, SCALING_CONFIGURATION_INFO_FIELD, DELETION_PROTECTION_FIELD, HTTP_ENDPOINT_ENABLED_FIELD, ACTIVITY_STREAM_MODE_FIELD, ACTIVITY_STREAM_STATUS_FIELD, ACTIVITY_STREAM_KMS_KEY_ID_FIELD, ACTIVITY_STREAM_KINESIS_STREAM_NAME_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, CROSS_ACCOUNT_CLONE_FIELD, DOMAIN_MEMBERSHIPS_FIELD, TAG_LIST_FIELD, GLOBAL_WRITE_FORWARDING_STATUS_FIELD, GLOBAL_WRITE_FORWARDING_REQUESTED_FIELD, PENDING_MODIFIED_VALUES_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, PERFORMANCE_INSIGHTS_ENABLED_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD, DB_SYSTEM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer allocatedStorage;
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroup;
    private final String dbSubnetGroup;
    private final String status;
    private final Instant automaticRestartTime;
    private final String percentProgress;
    private final Instant earliestRestorableTime;
    private final String endpoint;
    private final String readerEndpoint;
    private final List<String> customEndpoints;
    private final Boolean multiAZ;
    private final String engine;
    private final String engineVersion;
    private final Instant latestRestorableTime;
    private final Integer port;
    private final String masterUsername;
    private final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<String> readReplicaIdentifiers;
    private final List<DBClusterMember> dbClusterMembers;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String hostedZoneId;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterResourceId;
    private final String dbClusterArn;
    private final List<DBClusterRole> associatedRoles;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final String cloneGroupId;
    private final Instant clusterCreateTime;
    private final Instant earliestBacktrackTime;
    private final Long backtrackWindow;
    private final Long backtrackConsumedChangeRecords;
    private final List<String> enabledCloudwatchLogsExports;
    private final Integer capacity;
    private final String engineMode;
    private final ScalingConfigurationInfo scalingConfigurationInfo;
    private final Boolean deletionProtection;
    private final Boolean httpEndpointEnabled;
    private final String activityStreamMode;
    private final String activityStreamStatus;
    private final String activityStreamKmsKeyId;
    private final String activityStreamKinesisStreamName;
    private final Boolean copyTagsToSnapshot;
    private final Boolean crossAccountClone;
    private final List<DomainMembership> domainMemberships;
    private final List<Tag> tagList;
    private final String globalWriteForwardingStatus;
    private final Boolean globalWriteForwardingRequested;
    private final ClusterPendingModifiedValues pendingModifiedValues;
    private final String dbClusterInstanceClass;
    private final String storageType;
    private final Integer iops;
    private final Boolean publiclyAccessible;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final Boolean performanceInsightsEnabled;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration;
    private final String networkType;
    private final String dbSystemId;

    private DBCluster(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.automaticRestartTime = builder.automaticRestartTime;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.customEndpoints = builder.customEndpoints;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.cloneGroupId = builder.cloneGroupId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.earliestBacktrackTime = builder.earliestBacktrackTime;
        this.backtrackWindow = builder.backtrackWindow;
        this.backtrackConsumedChangeRecords = builder.backtrackConsumedChangeRecords;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.capacity = builder.capacity;
        this.engineMode = builder.engineMode;
        this.scalingConfigurationInfo = builder.scalingConfigurationInfo;
        this.deletionProtection = builder.deletionProtection;
        this.httpEndpointEnabled = builder.httpEndpointEnabled;
        this.activityStreamMode = builder.activityStreamMode;
        this.activityStreamStatus = builder.activityStreamStatus;
        this.activityStreamKmsKeyId = builder.activityStreamKmsKeyId;
        this.activityStreamKinesisStreamName = builder.activityStreamKinesisStreamName;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.crossAccountClone = builder.crossAccountClone;
        this.domainMemberships = builder.domainMemberships;
        this.tagList = builder.tagList;
        this.globalWriteForwardingStatus = builder.globalWriteForwardingStatus;
        this.globalWriteForwardingRequested = builder.globalWriteForwardingRequested;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.performanceInsightsEnabled = builder.performanceInsightsEnabled;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
        this.dbSystemId = builder.dbSystemId;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterParameterGroup() {
        return this.dbClusterParameterGroup;
    }

    public final String dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public final String status() {
        return this.status;
    }

    public final Instant automaticRestartTime() {
        return this.automaticRestartTime;
    }

    public final String percentProgress() {
        return this.percentProgress;
    }

    public final Instant earliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String readerEndpoint() {
        return this.readerEndpoint;
    }

    public final boolean hasCustomEndpoints() {
        return this.customEndpoints != null && !(this.customEndpoints instanceof SdkAutoConstructList);
    }

    public final List<String> customEndpoints() {
        return this.customEndpoints;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final boolean hasDbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships != null && !(this.dbClusterOptionGroupMemberships instanceof SdkAutoConstructList);
    }

    public final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public final boolean hasReadReplicaIdentifiers() {
        return this.readReplicaIdentifiers != null && !(this.readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> readReplicaIdentifiers() {
        return this.readReplicaIdentifiers;
    }

    public final boolean hasDbClusterMembers() {
        return this.dbClusterMembers != null && !(this.dbClusterMembers instanceof SdkAutoConstructList);
    }

    public final List<DBClusterMember> dbClusterMembers() {
        return this.dbClusterMembers;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public final String dbClusterArn() {
        return this.dbClusterArn;
    }

    public final boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public final List<DBClusterRole> associatedRoles() {
        return this.associatedRoles;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final String cloneGroupId() {
        return this.cloneGroupId;
    }

    public final Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final Instant earliestBacktrackTime() {
        return this.earliestBacktrackTime;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final Long backtrackConsumedChangeRecords() {
        return this.backtrackConsumedChangeRecords;
    }

    public final boolean hasEnabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports != null && !(this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final ScalingConfigurationInfo scalingConfigurationInfo() {
        return this.scalingConfigurationInfo;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean httpEndpointEnabled() {
        return this.httpEndpointEnabled;
    }

    public final ActivityStreamMode activityStreamMode() {
        return ActivityStreamMode.fromValue(this.activityStreamMode);
    }

    public final String activityStreamModeAsString() {
        return this.activityStreamMode;
    }

    public final ActivityStreamStatus activityStreamStatus() {
        return ActivityStreamStatus.fromValue(this.activityStreamStatus);
    }

    public final String activityStreamStatusAsString() {
        return this.activityStreamStatus;
    }

    public final String activityStreamKmsKeyId() {
        return this.activityStreamKmsKeyId;
    }

    public final String activityStreamKinesisStreamName() {
        return this.activityStreamKinesisStreamName;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Boolean crossAccountClone() {
        return this.crossAccountClone;
    }

    public final boolean hasDomainMemberships() {
        return this.domainMemberships != null && !(this.domainMemberships instanceof SdkAutoConstructList);
    }

    public final List<DomainMembership> domainMemberships() {
        return this.domainMemberships;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final WriteForwardingStatus globalWriteForwardingStatus() {
        return WriteForwardingStatus.fromValue(this.globalWriteForwardingStatus);
    }

    public final String globalWriteForwardingStatusAsString() {
        return this.globalWriteForwardingStatus;
    }

    public final Boolean globalWriteForwardingRequested() {
        return this.globalWriteForwardingRequested;
    }

    public final ClusterPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final String dbClusterInstanceClass() {
        return this.dbClusterInstanceClass;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final Boolean performanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final String dbSystemId() {
        return this.dbSystemId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticRestartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEndpoints() ? this.customEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterMembers() ? this.dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoles() ? this.associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestBacktrackTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackConsumedChangeRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfigurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStreamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStreamKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStreamKinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountClone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainMemberships() ? this.domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.globalWriteForwardingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalWriteForwardingRequested());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSystemId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        return Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroup(), other.dbClusterParameterGroup()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.automaticRestartTime(), other.automaticRestartTime()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.earliestRestorableTime(), other.earliestRestorableTime()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && this.hasCustomEndpoints() == other.hasCustomEndpoints() && Objects.equals(this.customEndpoints(), other.customEndpoints()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && this.hasDbClusterOptionGroupMemberships() == other.hasDbClusterOptionGroupMemberships() && Objects.equals(this.dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSourceIdentifier(), other.replicationSourceIdentifier()) && this.hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers() && Objects.equals(this.readReplicaIdentifiers(), other.readReplicaIdentifiers()) && this.hasDbClusterMembers() == other.hasDbClusterMembers() && Objects.equals(this.dbClusterMembers(), other.dbClusterMembers()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterResourceId(), other.dbClusterResourceId()) && Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && this.hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.cloneGroupId(), other.cloneGroupId()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.earliestBacktrackTime(), other.earliestBacktrackTime()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && Objects.equals(this.backtrackConsumedChangeRecords(), other.backtrackConsumedChangeRecords()) && this.hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports() && Objects.equals(this.enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.scalingConfigurationInfo(), other.scalingConfigurationInfo()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.httpEndpointEnabled(), other.httpEndpointEnabled()) && Objects.equals(this.activityStreamModeAsString(), other.activityStreamModeAsString()) && Objects.equals(this.activityStreamStatusAsString(), other.activityStreamStatusAsString()) && Objects.equals(this.activityStreamKmsKeyId(), other.activityStreamKmsKeyId()) && Objects.equals(this.activityStreamKinesisStreamName(), other.activityStreamKinesisStreamName()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.crossAccountClone(), other.crossAccountClone()) && this.hasDomainMemberships() == other.hasDomainMemberships() && Objects.equals(this.domainMemberships(), other.domainMemberships()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.globalWriteForwardingStatusAsString(), other.globalWriteForwardingStatusAsString()) && Objects.equals(this.globalWriteForwardingRequested(), other.globalWriteForwardingRequested()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.dbClusterInstanceClass(), other.dbClusterInstanceClass()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.performanceInsightsEnabled(), other.performanceInsightsEnabled()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && Objects.equals(this.serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.dbSystemId(), other.dbSystemId());
    }

    public final String toString() {
        return ToString.builder((String)"DBCluster").add("AllocatedStorage", (Object)this.allocatedStorage()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroup", (Object)this.dbClusterParameterGroup()).add("DBSubnetGroup", (Object)this.dbSubnetGroup()).add("Status", (Object)this.status()).add("AutomaticRestartTime", (Object)this.automaticRestartTime()).add("PercentProgress", (Object)this.percentProgress()).add("EarliestRestorableTime", (Object)this.earliestRestorableTime()).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("CustomEndpoints", this.hasCustomEndpoints() ? this.customEndpoints() : null).add("MultiAZ", (Object)this.multiAZ()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("DBClusterOptionGroupMemberships", this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSourceIdentifier", (Object)this.replicationSourceIdentifier()).add("ReadReplicaIdentifiers", this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null).add("DBClusterMembers", this.hasDbClusterMembers() ? this.dbClusterMembers() : null).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("HostedZoneId", (Object)this.hostedZoneId()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbClusterResourceId", (Object)this.dbClusterResourceId()).add("DBClusterArn", (Object)this.dbClusterArn()).add("AssociatedRoles", this.hasAssociatedRoles() ? this.associatedRoles() : null).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("CloneGroupId", (Object)this.cloneGroupId()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("EarliestBacktrackTime", (Object)this.earliestBacktrackTime()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("BacktrackConsumedChangeRecords", (Object)this.backtrackConsumedChangeRecords()).add("EnabledCloudwatchLogsExports", this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null).add("Capacity", (Object)this.capacity()).add("EngineMode", (Object)this.engineMode()).add("ScalingConfigurationInfo", (Object)this.scalingConfigurationInfo()).add("DeletionProtection", (Object)this.deletionProtection()).add("HttpEndpointEnabled", (Object)this.httpEndpointEnabled()).add("ActivityStreamMode", (Object)this.activityStreamModeAsString()).add("ActivityStreamStatus", (Object)this.activityStreamStatusAsString()).add("ActivityStreamKmsKeyId", (Object)this.activityStreamKmsKeyId()).add("ActivityStreamKinesisStreamName", (Object)this.activityStreamKinesisStreamName()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("CrossAccountClone", (Object)this.crossAccountClone()).add("DomainMemberships", this.hasDomainMemberships() ? this.domainMemberships() : null).add("TagList", this.hasTagList() ? this.tagList() : null).add("GlobalWriteForwardingStatus", (Object)this.globalWriteForwardingStatusAsString()).add("GlobalWriteForwardingRequested", (Object)this.globalWriteForwardingRequested()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("DBClusterInstanceClass", (Object)this.dbClusterInstanceClass()).add("StorageType", (Object)this.storageType()).add("Iops", (Object)this.iops()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("PerformanceInsightsEnabled", (Object)this.performanceInsightsEnabled()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("ServerlessV2ScalingConfiguration", (Object)this.serverlessV2ScalingConfiguration()).add("NetworkType", (Object)this.networkType()).add("DBSystemId", (Object)this.dbSystemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroup": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroup()));
            }
            case "DBSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroup()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "AutomaticRestartTime": {
                return Optional.ofNullable(clazz.cast(this.automaticRestartTime()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "EarliestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.earliestRestorableTime()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "CustomEndpoints": {
                return Optional.ofNullable(clazz.cast(this.customEndpoints()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableTime()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DBClusterOptionGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.dbClusterOptionGroupMemberships()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSourceIdentifier()));
            }
            case "ReadReplicaIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.readReplicaIdentifiers()));
            }
            case "DBClusterMembers": {
                return Optional.ofNullable(clazz.cast(this.dbClusterMembers()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbClusterResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterResourceId()));
            }
            case "DBClusterArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterArn()));
            }
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "CloneGroupId": {
                return Optional.ofNullable(clazz.cast(this.cloneGroupId()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "EarliestBacktrackTime": {
                return Optional.ofNullable(clazz.cast(this.earliestBacktrackTime()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "BacktrackConsumedChangeRecords": {
                return Optional.ofNullable(clazz.cast(this.backtrackConsumedChangeRecords()));
            }
            case "EnabledCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enabledCloudwatchLogsExports()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "ScalingConfigurationInfo": {
                return Optional.ofNullable(clazz.cast(this.scalingConfigurationInfo()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "HttpEndpointEnabled": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointEnabled()));
            }
            case "ActivityStreamMode": {
                return Optional.ofNullable(clazz.cast(this.activityStreamModeAsString()));
            }
            case "ActivityStreamStatus": {
                return Optional.ofNullable(clazz.cast(this.activityStreamStatusAsString()));
            }
            case "ActivityStreamKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.activityStreamKmsKeyId()));
            }
            case "ActivityStreamKinesisStreamName": {
                return Optional.ofNullable(clazz.cast(this.activityStreamKinesisStreamName()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "CrossAccountClone": {
                return Optional.ofNullable(clazz.cast(this.crossAccountClone()));
            }
            case "DomainMemberships": {
                return Optional.ofNullable(clazz.cast(this.domainMemberships()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "GlobalWriteForwardingStatus": {
                return Optional.ofNullable(clazz.cast(this.globalWriteForwardingStatusAsString()));
            }
            case "GlobalWriteForwardingRequested": {
                return Optional.ofNullable(clazz.cast(this.globalWriteForwardingRequested()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "DBClusterInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbClusterInstanceClass()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "PerformanceInsightsEnabled": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsEnabled()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "ServerlessV2ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2ScalingConfiguration()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "DBSystemId": {
                return Optional.ofNullable(clazz.cast(this.dbSystemId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBCluster, T> g) {
        return obj -> g.apply((DBCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroup;
        private String dbSubnetGroup;
        private String status;
        private Instant automaticRestartTime;
        private String percentProgress;
        private Instant earliestRestorableTime;
        private String endpoint;
        private String readerEndpoint;
        private List<String> customEndpoints = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiAZ;
        private String engine;
        private String engineVersion;
        private Instant latestRestorableTime;
        private Integer port;
        private String masterUsername;
        private List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<DBClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String hostedZoneId;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterResourceId;
        private String dbClusterArn;
        private List<DBClusterRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();
        private Boolean iamDatabaseAuthenticationEnabled;
        private String cloneGroupId;
        private Instant clusterCreateTime;
        private Instant earliestBacktrackTime;
        private Long backtrackWindow;
        private Long backtrackConsumedChangeRecords;
        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private Integer capacity;
        private String engineMode;
        private ScalingConfigurationInfo scalingConfigurationInfo;
        private Boolean deletionProtection;
        private Boolean httpEndpointEnabled;
        private String activityStreamMode;
        private String activityStreamStatus;
        private String activityStreamKmsKeyId;
        private String activityStreamKinesisStreamName;
        private Boolean copyTagsToSnapshot;
        private Boolean crossAccountClone;
        private List<DomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private String globalWriteForwardingStatus;
        private Boolean globalWriteForwardingRequested;
        private ClusterPendingModifiedValues pendingModifiedValues;
        private String dbClusterInstanceClass;
        private String storageType;
        private Integer iops;
        private Boolean publiclyAccessible;
        private Boolean autoMinorVersionUpgrade;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private Boolean performanceInsightsEnabled;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration;
        private String networkType;
        private String dbSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            this.allocatedStorage(model.allocatedStorage);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroup(model.dbClusterParameterGroup);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.status(model.status);
            this.automaticRestartTime(model.automaticRestartTime);
            this.percentProgress(model.percentProgress);
            this.earliestRestorableTime(model.earliestRestorableTime);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.customEndpoints(model.customEndpoints);
            this.multiAZ(model.multiAZ);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.latestRestorableTime(model.latestRestorableTime);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSourceIdentifier(model.replicationSourceIdentifier);
            this.readReplicaIdentifiers(model.readReplicaIdentifiers);
            this.dbClusterMembers(model.dbClusterMembers);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.hostedZoneId(model.hostedZoneId);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterResourceId(model.dbClusterResourceId);
            this.dbClusterArn(model.dbClusterArn);
            this.associatedRoles(model.associatedRoles);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.cloneGroupId(model.cloneGroupId);
            this.clusterCreateTime(model.clusterCreateTime);
            this.earliestBacktrackTime(model.earliestBacktrackTime);
            this.backtrackWindow(model.backtrackWindow);
            this.backtrackConsumedChangeRecords(model.backtrackConsumedChangeRecords);
            this.enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            this.capacity(model.capacity);
            this.engineMode(model.engineMode);
            this.scalingConfigurationInfo(model.scalingConfigurationInfo);
            this.deletionProtection(model.deletionProtection);
            this.httpEndpointEnabled(model.httpEndpointEnabled);
            this.activityStreamMode(model.activityStreamMode);
            this.activityStreamStatus(model.activityStreamStatus);
            this.activityStreamKmsKeyId(model.activityStreamKmsKeyId);
            this.activityStreamKinesisStreamName(model.activityStreamKinesisStreamName);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.crossAccountClone(model.crossAccountClone);
            this.domainMemberships(model.domainMemberships);
            this.tagList(model.tagList);
            this.globalWriteForwardingStatus(model.globalWriteForwardingStatus);
            this.globalWriteForwardingRequested(model.globalWriteForwardingRequested);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.dbClusterInstanceClass(model.dbClusterInstanceClass);
            this.storageType(model.storageType);
            this.iops(model.iops);
            this.publiclyAccessible(model.publiclyAccessible);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.performanceInsightsEnabled(model.performanceInsightsEnabled);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            this.networkType(model.networkType);
            this.dbSystemId(model.dbSystemId);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroup() {
            return this.dbClusterParameterGroup;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final String getDbSubnetGroup() {
            return this.dbSubnetGroup;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getAutomaticRestartTime() {
            return this.automaticRestartTime;
        }

        public final void setAutomaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
        }

        @Override
        public final Builder automaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
            return this;
        }

        public final String getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final Instant getEarliestRestorableTime() {
            return this.earliestRestorableTime;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        @Override
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Collection<String> getCustomEndpoints() {
            if (this.customEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customEndpoints;
        }

        public final void setCustomEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
        }

        @Override
        public final Builder customEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEndpoints(String ... customEndpoints) {
            this.customEndpoints(Arrays.asList(customEndpoints));
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final List<DBClusterOptionGroupStatus.Builder> getDbClusterOptionGroupMemberships() {
            List<DBClusterOptionGroupStatus.Builder> result = DBClusterOptionGroupMembershipsCopier.copyToBuilder(this.dbClusterOptionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(Consumer<DBClusterOptionGroupStatus.Builder> ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Stream.of(dbClusterOptionGroupMemberships).map(c -> (DBClusterOptionGroupStatus)((DBClusterOptionGroupStatus.Builder)DBClusterOptionGroupStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (this.readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readReplicaIdentifiers;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final List<DBClusterMember.Builder> getDbClusterMembers() {
            List<DBClusterMember.Builder> result = DBClusterMemberListCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterMembers(Collection<DBClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copyFromBuilder(dbClusterMembers);
        }

        @Override
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<DBClusterMember.Builder> ... dbClusterMembers) {
            this.dbClusterMembers(Stream.of(dbClusterMembers).map(c -> (DBClusterMember)((DBClusterMember.Builder)DBClusterMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final String getDbClusterArn() {
            return this.dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final List<DBClusterRole.Builder> getAssociatedRoles() {
            List<DBClusterRole.Builder> result = DBClusterRolesCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<DBClusterRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (DBClusterRole)((DBClusterRole.Builder)DBClusterRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final String getCloneGroupId() {
            return this.cloneGroupId;
        }

        public final void setCloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
        }

        @Override
        public final Builder cloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Instant getEarliestBacktrackTime() {
            return this.earliestBacktrackTime;
        }

        public final void setEarliestBacktrackTime(Instant earliestBacktrackTime) {
            this.earliestBacktrackTime = earliestBacktrackTime;
        }

        @Override
        public final Builder earliestBacktrackTime(Instant earliestBacktrackTime) {
            this.earliestBacktrackTime = earliestBacktrackTime;
            return this;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Long getBacktrackConsumedChangeRecords() {
            return this.backtrackConsumedChangeRecords;
        }

        public final void setBacktrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
            this.backtrackConsumedChangeRecords = backtrackConsumedChangeRecords;
        }

        @Override
        public final Builder backtrackConsumedChangeRecords(Long backtrackConsumedChangeRecords) {
            this.backtrackConsumedChangeRecords = backtrackConsumedChangeRecords;
            return this;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledCloudwatchLogsExports;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final ScalingConfigurationInfo.Builder getScalingConfigurationInfo() {
            return this.scalingConfigurationInfo != null ? this.scalingConfigurationInfo.toBuilder() : null;
        }

        public final void setScalingConfigurationInfo(ScalingConfigurationInfo.BuilderImpl scalingConfigurationInfo) {
            this.scalingConfigurationInfo = scalingConfigurationInfo != null ? scalingConfigurationInfo.build() : null;
        }

        @Override
        public final Builder scalingConfigurationInfo(ScalingConfigurationInfo scalingConfigurationInfo) {
            this.scalingConfigurationInfo = scalingConfigurationInfo;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getHttpEndpointEnabled() {
            return this.httpEndpointEnabled;
        }

        public final void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
        }

        @Override
        public final Builder httpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
            return this;
        }

        public final String getActivityStreamMode() {
            return this.activityStreamMode;
        }

        public final void setActivityStreamMode(String activityStreamMode) {
            this.activityStreamMode = activityStreamMode;
        }

        @Override
        public final Builder activityStreamMode(String activityStreamMode) {
            this.activityStreamMode = activityStreamMode;
            return this;
        }

        @Override
        public final Builder activityStreamMode(ActivityStreamMode activityStreamMode) {
            this.activityStreamMode(activityStreamMode == null ? null : activityStreamMode.toString());
            return this;
        }

        public final String getActivityStreamStatus() {
            return this.activityStreamStatus;
        }

        public final void setActivityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
        }

        @Override
        public final Builder activityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
            return this;
        }

        @Override
        public final Builder activityStreamStatus(ActivityStreamStatus activityStreamStatus) {
            this.activityStreamStatus(activityStreamStatus == null ? null : activityStreamStatus.toString());
            return this;
        }

        public final String getActivityStreamKmsKeyId() {
            return this.activityStreamKmsKeyId;
        }

        public final void setActivityStreamKmsKeyId(String activityStreamKmsKeyId) {
            this.activityStreamKmsKeyId = activityStreamKmsKeyId;
        }

        @Override
        public final Builder activityStreamKmsKeyId(String activityStreamKmsKeyId) {
            this.activityStreamKmsKeyId = activityStreamKmsKeyId;
            return this;
        }

        public final String getActivityStreamKinesisStreamName() {
            return this.activityStreamKinesisStreamName;
        }

        public final void setActivityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
            this.activityStreamKinesisStreamName = activityStreamKinesisStreamName;
        }

        @Override
        public final Builder activityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
            this.activityStreamKinesisStreamName = activityStreamKinesisStreamName;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Boolean getCrossAccountClone() {
            return this.crossAccountClone;
        }

        public final void setCrossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
        }

        @Override
        public final Builder crossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
            return this;
        }

        public final List<DomainMembership.Builder> getDomainMemberships() {
            List<DomainMembership.Builder> result = DomainMembershipListCopier.copyToBuilder(this.domainMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainMemberships(Collection<DomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copyFromBuilder(domainMemberships);
        }

        @Override
        public final Builder domainMemberships(Collection<DomainMembership> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(DomainMembership ... domainMemberships) {
            this.domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<DomainMembership.Builder> ... domainMemberships) {
            this.domainMemberships(Stream.of(domainMemberships).map(c -> (DomainMembership)((DomainMembership.Builder)DomainMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGlobalWriteForwardingStatus() {
            return this.globalWriteForwardingStatus;
        }

        public final void setGlobalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
        }

        @Override
        public final Builder globalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
            return this;
        }

        @Override
        public final Builder globalWriteForwardingStatus(WriteForwardingStatus globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus(globalWriteForwardingStatus == null ? null : globalWriteForwardingStatus.toString());
            return this;
        }

        public final Boolean getGlobalWriteForwardingRequested() {
            return this.globalWriteForwardingRequested;
        }

        public final void setGlobalWriteForwardingRequested(Boolean globalWriteForwardingRequested) {
            this.globalWriteForwardingRequested = globalWriteForwardingRequested;
        }

        @Override
        public final Builder globalWriteForwardingRequested(Boolean globalWriteForwardingRequested) {
            this.globalWriteForwardingRequested = globalWriteForwardingRequested;
            return this;
        }

        public final ClusterPendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(ClusterPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ClusterPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return this.dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getPerformanceInsightsEnabled() {
            return this.performanceInsightsEnabled;
        }

        public final void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
        }

        @Override
        public final Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final ServerlessV2ScalingConfigurationInfo.Builder getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final String getDbSystemId() {
            return this.dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public DBCluster build() {
            return new DBCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBCluster> {
        public Builder allocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroup(String var1);

        public Builder dbSubnetGroup(String var1);

        public Builder status(String var1);

        public Builder automaticRestartTime(Instant var1);

        public Builder percentProgress(String var1);

        public Builder earliestRestorableTime(Instant var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder customEndpoints(Collection<String> var1);

        public Builder customEndpoints(String ... var1);

        public Builder multiAZ(Boolean var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder latestRestorableTime(Instant var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> var1);

        public Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... var1);

        public Builder dbClusterOptionGroupMemberships(Consumer<DBClusterOptionGroupStatus.Builder> ... var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder readReplicaIdentifiers(Collection<String> var1);

        public Builder readReplicaIdentifiers(String ... var1);

        public Builder dbClusterMembers(Collection<DBClusterMember> var1);

        public Builder dbClusterMembers(DBClusterMember ... var1);

        public Builder dbClusterMembers(Consumer<DBClusterMember.Builder> ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder hostedZoneId(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder dbClusterArn(String var1);

        public Builder associatedRoles(Collection<DBClusterRole> var1);

        public Builder associatedRoles(DBClusterRole ... var1);

        public Builder associatedRoles(Consumer<DBClusterRole.Builder> ... var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder cloneGroupId(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder earliestBacktrackTime(Instant var1);

        public Builder backtrackWindow(Long var1);

        public Builder backtrackConsumedChangeRecords(Long var1);

        public Builder enabledCloudwatchLogsExports(Collection<String> var1);

        public Builder enabledCloudwatchLogsExports(String ... var1);

        public Builder capacity(Integer var1);

        public Builder engineMode(String var1);

        public Builder scalingConfigurationInfo(ScalingConfigurationInfo var1);

        default public Builder scalingConfigurationInfo(Consumer<ScalingConfigurationInfo.Builder> scalingConfigurationInfo) {
            return this.scalingConfigurationInfo((ScalingConfigurationInfo)((ScalingConfigurationInfo.Builder)ScalingConfigurationInfo.builder().applyMutation(scalingConfigurationInfo)).build());
        }

        public Builder deletionProtection(Boolean var1);

        public Builder httpEndpointEnabled(Boolean var1);

        public Builder activityStreamMode(String var1);

        public Builder activityStreamMode(ActivityStreamMode var1);

        public Builder activityStreamStatus(String var1);

        public Builder activityStreamStatus(ActivityStreamStatus var1);

        public Builder activityStreamKmsKeyId(String var1);

        public Builder activityStreamKinesisStreamName(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder crossAccountClone(Boolean var1);

        public Builder domainMemberships(Collection<DomainMembership> var1);

        public Builder domainMemberships(DomainMembership ... var1);

        public Builder domainMemberships(Consumer<DomainMembership.Builder> ... var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder globalWriteForwardingStatus(String var1);

        public Builder globalWriteForwardingStatus(WriteForwardingStatus var1);

        public Builder globalWriteForwardingRequested(Boolean var1);

        public Builder pendingModifiedValues(ClusterPendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<ClusterPendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((ClusterPendingModifiedValues)((ClusterPendingModifiedValues.Builder)ClusterPendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder dbClusterInstanceClass(String var1);

        public Builder storageType(String var1);

        public Builder iops(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder performanceInsightsEnabled(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo var1);

        default public Builder serverlessV2ScalingConfiguration(Consumer<ServerlessV2ScalingConfigurationInfo.Builder> serverlessV2ScalingConfiguration) {
            return this.serverlessV2ScalingConfiguration((ServerlessV2ScalingConfigurationInfo)((ServerlessV2ScalingConfigurationInfo.Builder)ServerlessV2ScalingConfigurationInfo.builder().applyMutation(serverlessV2ScalingConfiguration)).build());
        }

        public Builder networkType(String var1);

        public Builder dbSystemId(String var1);
    }
}

