/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.Event;

public class DescribeEventsPublisher
implements SdkPublisher<DescribeEventsResponse> {
    private final RdsAsyncClient client;
    private final DescribeEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventsPublisher(RdsAsyncClient client, DescribeEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventsPublisher(RdsAsyncClient client, DescribeEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEventsResponseFetcher
    implements AsyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEventsResponse> nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsPublisher.this.client.describeEvents(DescribeEventsPublisher.this.firstRequest);
            }
            return DescribeEventsPublisher.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

