/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroup;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.services.rds.model.IPRange;
import software.amazon.awssdk.services.rds.model.IPRangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBSecurityGroup> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(DBSecurityGroup.getter(DBSecurityGroup::ownerId)).setter(DBSecurityGroup.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSecurityGroupName").getter(DBSecurityGroup.getter(DBSecurityGroup::dbSecurityGroupName)).setter(DBSecurityGroup.setter(Builder::dbSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSecurityGroupDescription").getter(DBSecurityGroup.getter(DBSecurityGroup::dbSecurityGroupDescription)).setter(DBSecurityGroup.setter(Builder::dbSecurityGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupDescription").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DBSecurityGroup.getter(DBSecurityGroup::vpcId)).setter(DBSecurityGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2SecurityGroups").getter(DBSecurityGroup.getter(DBSecurityGroup::ec2SecurityGroups)).setter(DBSecurityGroup.setter(Builder::ec2SecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(), ListTrait.builder().memberLocationName("EC2SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2SecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<IPRange>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IPRanges").getter(DBSecurityGroup.getter(DBSecurityGroup::ipRanges)).setter(DBSecurityGroup.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRanges").build(), ListTrait.builder().memberLocationName("IPRange").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRange").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSecurityGroupArn").getter(DBSecurityGroup.getter(DBSecurityGroup::dbSecurityGroupArn)).setter(DBSecurityGroup.setter(Builder::dbSecurityGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, DB_SECURITY_GROUP_NAME_FIELD, DB_SECURITY_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD, EC2_SECURITY_GROUPS_FIELD, IP_RANGES_FIELD, DB_SECURITY_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String dbSecurityGroupName;
    private final String dbSecurityGroupDescription;
    private final String vpcId;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final List<IPRange> ipRanges;
    private final String dbSecurityGroupArn;

    private DBSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.vpcId = builder.vpcId;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.dbSecurityGroupArn = builder.dbSecurityGroupArn;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public String dbSecurityGroupDescription() {
        return this.dbSecurityGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public boolean hasEc2SecurityGroups() {
        return this.ec2SecurityGroups != null && !(this.ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public List<IPRange> ipRanges() {
        return this.ipRanges;
    }

    public String dbSecurityGroupArn() {
        return this.dbSecurityGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroup)) {
            return false;
        }
        DBSecurityGroup other = (DBSecurityGroup)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(this.dbSecurityGroupDescription(), other.dbSecurityGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ec2SecurityGroups(), other.ec2SecurityGroups()) && Objects.equals(this.ipRanges(), other.ipRanges()) && Objects.equals(this.dbSecurityGroupArn(), other.dbSecurityGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"DBSecurityGroup").add("OwnerId", (Object)this.ownerId()).add("DBSecurityGroupName", (Object)this.dbSecurityGroupName()).add("DBSecurityGroupDescription", (Object)this.dbSecurityGroupDescription()).add("VpcId", (Object)this.vpcId()).add("EC2SecurityGroups", this.ec2SecurityGroups()).add("IPRanges", this.ipRanges()).add("DBSecurityGroupArn", (Object)this.dbSecurityGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "DBSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupName()));
            }
            case "DBSecurityGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupDescription()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "EC2SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroups()));
            }
            case "IPRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "DBSecurityGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSecurityGroup, T> g) {
        return obj -> g.apply((DBSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String dbSecurityGroupName;
        private String dbSecurityGroupDescription;
        private String vpcId;
        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<IPRange> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private String dbSecurityGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSecurityGroup model) {
            this.ownerId(model.ownerId);
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.dbSecurityGroupDescription(model.dbSecurityGroupDescription);
            this.vpcId(model.vpcId);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
            this.ipRanges(model.ipRanges);
            this.dbSecurityGroupArn(model.dbSecurityGroupArn);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getDbSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getDbSecurityGroupDescription() {
            return this.dbSecurityGroupDescription;
        }

        @Override
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final void setDbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            return this.ec2SecurityGroups != null ? (Collection)this.ec2SecurityGroups.stream().map(EC2SecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> (EC2SecurityGroup)((EC2SecurityGroup.Builder)EC2SecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public final Collection<IPRange.Builder> getIpRanges() {
            return this.ipRanges != null ? (Collection)this.ipRanges.stream().map(IPRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<IPRange.Builder> ... ipRanges) {
            this.ipRanges(Stream.of(ipRanges).map(c -> (IPRange)((IPRange.Builder)IPRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<IPRange.BuilderImpl> ipRanges) {
            this.ipRanges = IPRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final String getDbSecurityGroupArn() {
            return this.dbSecurityGroupArn;
        }

        @Override
        public final Builder dbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
            return this;
        }

        public final void setDbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
        }

        public DBSecurityGroup build() {
            return new DBSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBSecurityGroup> {
        public Builder ownerId(String var1);

        public Builder dbSecurityGroupName(String var1);

        public Builder dbSecurityGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... var1);

        public Builder ipRanges(Collection<IPRange> var1);

        public Builder ipRanges(IPRange ... var1);

        public Builder ipRanges(Consumer<IPRange.Builder> ... var1);

        public Builder dbSecurityGroupArn(String var1);
    }
}

