/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.EngineFamily;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.UserAuthConfig;
import software.amazon.awssdk.services.rds.model.UserAuthConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbProxyRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbProxyRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::dbProxyName)).setter(CreateDbProxyRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> ENGINE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineFamily").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::engineFamilyAsString)).setter(CreateDbProxyRequest.setter(Builder::engineFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineFamily").build()}).build();
    private static final SdkField<List<UserAuthConfig>> AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Auth").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::auth)).setter(CreateDbProxyRequest.setter(Builder::auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auth").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::roleArn)).setter(CreateDbProxyRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSubnetIds").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::vpcSubnetIds)).setter(CreateDbProxyRequest.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::vpcSecurityGroupIds)).setter(CreateDbProxyRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REQUIRE_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireTLS").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::requireTLS)).setter(CreateDbProxyRequest.setter(Builder::requireTLS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireTLS").build()}).build();
    private static final SdkField<Integer> IDLE_CLIENT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleClientTimeout").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::idleClientTimeout)).setter(CreateDbProxyRequest.setter(Builder::idleClientTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleClientTimeout").build()}).build();
    private static final SdkField<Boolean> DEBUG_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DebugLogging").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::debugLogging)).setter(CreateDbProxyRequest.setter(Builder::debugLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogging").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDbProxyRequest.getter(CreateDbProxyRequest::tags)).setter(CreateDbProxyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, ENGINE_FAMILY_FIELD, AUTH_FIELD, ROLE_ARN_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, REQUIRE_TLS_FIELD, IDLE_CLIENT_TIMEOUT_FIELD, DEBUG_LOGGING_FIELD, TAGS_FIELD));
    private final String dbProxyName;
    private final String engineFamily;
    private final List<UserAuthConfig> auth;
    private final String roleArn;
    private final List<String> vpcSubnetIds;
    private final List<String> vpcSecurityGroupIds;
    private final Boolean requireTLS;
    private final Integer idleClientTimeout;
    private final Boolean debugLogging;
    private final List<Tag> tags;

    private CreateDbProxyRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.engineFamily = builder.engineFamily;
        this.auth = builder.auth;
        this.roleArn = builder.roleArn;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.requireTLS = builder.requireTLS;
        this.idleClientTimeout = builder.idleClientTimeout;
        this.debugLogging = builder.debugLogging;
        this.tags = builder.tags;
    }

    public String dbProxyName() {
        return this.dbProxyName;
    }

    public EngineFamily engineFamily() {
        return EngineFamily.fromValue(this.engineFamily);
    }

    public String engineFamilyAsString() {
        return this.engineFamily;
    }

    public boolean hasAuth() {
        return this.auth != null && !(this.auth instanceof SdkAutoConstructList);
    }

    public List<UserAuthConfig> auth() {
        return this.auth;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public Boolean requireTLS() {
        return this.requireTLS;
    }

    public Integer idleClientTimeout() {
        return this.idleClientTimeout;
    }

    public Boolean debugLogging() {
        return this.debugLogging;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireTLS());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleClientTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugLogging());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbProxyRequest)) {
            return false;
        }
        CreateDbProxyRequest other = (CreateDbProxyRequest)((Object)obj);
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.engineFamilyAsString(), other.engineFamilyAsString()) && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.requireTLS(), other.requireTLS()) && Objects.equals(this.idleClientTimeout(), other.idleClientTimeout()) && Objects.equals(this.debugLogging(), other.debugLogging()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDbProxyRequest").add("DBProxyName", (Object)this.dbProxyName()).add("EngineFamily", (Object)this.engineFamilyAsString()).add("Auth", this.auth()).add("RoleArn", (Object)this.roleArn()).add("VpcSubnetIds", this.vpcSubnetIds()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("RequireTLS", (Object)this.requireTLS()).add("IdleClientTimeout", (Object)this.idleClientTimeout()).add("DebugLogging", (Object)this.debugLogging()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "EngineFamily": {
                return Optional.ofNullable(clazz.cast(this.engineFamilyAsString()));
            }
            case "Auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "VpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "RequireTLS": {
                return Optional.ofNullable(clazz.cast(this.requireTLS()));
            }
            case "IdleClientTimeout": {
                return Optional.ofNullable(clazz.cast(this.idleClientTimeout()));
            }
            case "DebugLogging": {
                return Optional.ofNullable(clazz.cast(this.debugLogging()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbProxyRequest, T> g) {
        return obj -> g.apply((CreateDbProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String engineFamily;
        private List<UserAuthConfig> auth = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean requireTLS;
        private Integer idleClientTimeout;
        private Boolean debugLogging;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbProxyRequest model) {
            super(model);
            this.dbProxyName(model.dbProxyName);
            this.engineFamily(model.engineFamily);
            this.auth(model.auth);
            this.roleArn(model.roleArn);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.requireTLS(model.requireTLS);
            this.idleClientTimeout(model.idleClientTimeout);
            this.debugLogging(model.debugLogging);
            this.tags(model.tags);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        public final String getEngineFamily() {
            return this.engineFamily;
        }

        @Override
        public final Builder engineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
            return this;
        }

        @Override
        public final Builder engineFamily(EngineFamily engineFamily) {
            this.engineFamily(engineFamily == null ? null : engineFamily.toString());
            return this;
        }

        public final void setEngineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
        }

        public final Collection<UserAuthConfig.Builder> getAuth() {
            return this.auth != null ? (Collection)this.auth.stream().map(UserAuthConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder auth(Collection<UserAuthConfig> auth) {
            this.auth = UserAuthConfigListCopier.copy(auth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(UserAuthConfig ... auth) {
            this.auth(Arrays.asList(auth));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(Consumer<UserAuthConfig.Builder> ... auth) {
            this.auth(Stream.of(auth).map(c -> (UserAuthConfig)((UserAuthConfig.Builder)UserAuthConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuth(Collection<UserAuthConfig.BuilderImpl> auth) {
            this.auth = UserAuthConfigListCopier.copyFromBuilder(auth);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getVpcSubnetIds() {
            return this.vpcSubnetIds;
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        public final Boolean getRequireTLS() {
            return this.requireTLS;
        }

        @Override
        public final Builder requireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
            return this;
        }

        public final void setRequireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
        }

        public final Integer getIdleClientTimeout() {
            return this.idleClientTimeout;
        }

        @Override
        public final Builder idleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public final void setIdleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
        }

        public final Boolean getDebugLogging() {
            return this.debugLogging;
        }

        @Override
        public final Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public final void setDebugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbProxyRequest build() {
            return new CreateDbProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbProxyRequest> {
        public Builder dbProxyName(String var1);

        public Builder engineFamily(String var1);

        public Builder engineFamily(EngineFamily var1);

        public Builder auth(Collection<UserAuthConfig> var1);

        public Builder auth(UserAuthConfig ... var1);

        public Builder auth(Consumer<UserAuthConfig.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder requireTLS(Boolean var1);

        public Builder idleClientTimeout(Integer var1);

        public Builder debugLogging(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

