/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest;
import software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse;
import software.amazon.awssdk.services.rds.model.InstallationMedia;

public class DescribeInstallationMediaPublisher
implements SdkPublisher<DescribeInstallationMediaResponse> {
    private final RdsAsyncClient client;
    private final DescribeInstallationMediaRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstallationMediaPublisher(RdsAsyncClient client, DescribeInstallationMediaRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstallationMediaPublisher(RdsAsyncClient client, DescribeInstallationMediaRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstallationMediaResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstallationMediaResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstallationMedia> installationMedia() {
        Function<DescribeInstallationMediaResponse, Iterator> getIterator = response -> {
            if (response != null && response.installationMedia() != null) {
                return response.installationMedia().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstallationMediaResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstallationMediaResponseFetcher
    implements AsyncPageFetcher<DescribeInstallationMediaResponse> {
        private DescribeInstallationMediaResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstallationMediaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeInstallationMediaResponse> nextPage(DescribeInstallationMediaResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstallationMediaPublisher.this.client.describeInstallationMedia(DescribeInstallationMediaPublisher.this.firstRequest);
            }
            return DescribeInstallationMediaPublisher.this.client.describeInstallationMedia((DescribeInstallationMediaRequest)((Object)DescribeInstallationMediaPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

