/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.SourceRegion;

public class DescribeSourceRegionsIterable
implements SdkIterable<DescribeSourceRegionsResponse> {
    private final RdsClient client;
    private final DescribeSourceRegionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSourceRegionsIterable(RdsClient client, DescribeSourceRegionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSourceRegionsResponseFetcher();
    }

    public Iterator<DescribeSourceRegionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceRegion> sourceRegions() {
        Function<DescribeSourceRegionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceRegions() != null) {
                return response.sourceRegions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSourceRegionsResponseFetcher
    implements SyncPageFetcher<DescribeSourceRegionsResponse> {
        private DescribeSourceRegionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeSourceRegionsResponse nextPage(DescribeSourceRegionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceRegionsIterable.this.client.describeSourceRegions(DescribeSourceRegionsIterable.this.firstRequest);
            }
            return DescribeSourceRegionsIterable.this.client.describeSourceRegions((DescribeSourceRegionsRequest)((Object)DescribeSourceRegionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

