/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterEndpoint> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::dbClusterEndpointIdentifier)).setter(DBClusterEndpoint.setter(Builder::dbClusterEndpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::dbClusterIdentifier)).setter(DBClusterEndpoint.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::dbClusterEndpointResourceIdentifier)).setter(DBClusterEndpoint.setter(Builder::dbClusterEndpointResourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointResourceIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::endpoint)).setter(DBClusterEndpoint.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::status)).setter(DBClusterEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::endpointType)).setter(DBClusterEndpoint.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> CUSTOM_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::customEndpointType)).setter(DBClusterEndpoint.setter(Builder::customEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointType").build()}).build();
    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DBClusterEndpoint.getter(DBClusterEndpoint::staticMembers)).setter(DBClusterEndpoint.setter(Builder::staticMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DBClusterEndpoint.getter(DBClusterEndpoint::excludedMembers)).setter(DBClusterEndpoint.setter(Builder::excludedMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBClusterEndpoint.getter(DBClusterEndpoint::dbClusterEndpointArn)).setter(DBClusterEndpoint.setter(Builder::dbClusterEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD, ENDPOINT_FIELD, STATUS_FIELD, ENDPOINT_TYPE_FIELD, CUSTOM_ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD, DB_CLUSTER_ENDPOINT_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbClusterEndpointIdentifier;
    private final String dbClusterIdentifier;
    private final String dbClusterEndpointResourceIdentifier;
    private final String endpoint;
    private final String status;
    private final String endpointType;
    private final String customEndpointType;
    private final List<String> staticMembers;
    private final List<String> excludedMembers;
    private final String dbClusterEndpointArn;

    private DBClusterEndpoint(BuilderImpl builder) {
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterEndpointResourceIdentifier = builder.dbClusterEndpointResourceIdentifier;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.endpointType = builder.endpointType;
        this.customEndpointType = builder.customEndpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
        this.dbClusterEndpointArn = builder.dbClusterEndpointArn;
    }

    public String dbClusterEndpointIdentifier() {
        return this.dbClusterEndpointIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterEndpointResourceIdentifier() {
        return this.dbClusterEndpointResourceIdentifier;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String status() {
        return this.status;
    }

    public String endpointType() {
        return this.endpointType;
    }

    public String customEndpointType() {
        return this.customEndpointType;
    }

    public boolean hasStaticMembers() {
        return this.staticMembers != null && !(this.staticMembers instanceof SdkAutoConstructList);
    }

    public List<String> staticMembers() {
        return this.staticMembers;
    }

    public boolean hasExcludedMembers() {
        return this.excludedMembers != null && !(this.excludedMembers instanceof SdkAutoConstructList);
    }

    public List<String> excludedMembers() {
        return this.excludedMembers;
    }

    public String dbClusterEndpointArn() {
        return this.dbClusterEndpointArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointResourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEndpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterEndpoint)) {
            return false;
        }
        DBClusterEndpoint other = (DBClusterEndpoint)obj;
        return Objects.equals(this.dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterEndpointResourceIdentifier(), other.dbClusterEndpointResourceIdentifier()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.endpointType(), other.endpointType()) && Objects.equals(this.customEndpointType(), other.customEndpointType()) && Objects.equals(this.staticMembers(), other.staticMembers()) && Objects.equals(this.excludedMembers(), other.excludedMembers()) && Objects.equals(this.dbClusterEndpointArn(), other.dbClusterEndpointArn());
    }

    public String toString() {
        return ToString.builder((String)"DBClusterEndpoint").add("DBClusterEndpointIdentifier", (Object)this.dbClusterEndpointIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterEndpointResourceIdentifier", (Object)this.dbClusterEndpointResourceIdentifier()).add("Endpoint", (Object)this.endpoint()).add("Status", (Object)this.status()).add("EndpointType", (Object)this.endpointType()).add("CustomEndpointType", (Object)this.customEndpointType()).add("StaticMembers", this.staticMembers()).add("ExcludedMembers", this.excludedMembers()).add("DBClusterEndpointArn", (Object)this.dbClusterEndpointArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterEndpointResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointResourceIdentifier()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointType()));
            }
            case "CustomEndpointType": {
                return Optional.ofNullable(clazz.cast(this.customEndpointType()));
            }
            case "StaticMembers": {
                return Optional.ofNullable(clazz.cast(this.staticMembers()));
            }
            case "ExcludedMembers": {
                return Optional.ofNullable(clazz.cast(this.excludedMembers()));
            }
            case "DBClusterEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterEndpoint, T> g) {
        return obj -> g.apply((DBClusterEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterEndpointIdentifier;
        private String dbClusterIdentifier;
        private String dbClusterEndpointResourceIdentifier;
        private String endpoint;
        private String status;
        private String endpointType;
        private String customEndpointType;
        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterEndpoint model) {
            this.dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterEndpointResourceIdentifier(model.dbClusterEndpointResourceIdentifier);
            this.endpoint(model.endpoint);
            this.status(model.status);
            this.endpointType(model.endpointType);
            this.customEndpointType(model.customEndpointType);
            this.staticMembers(model.staticMembers);
            this.excludedMembers(model.excludedMembers);
            this.dbClusterEndpointArn(model.dbClusterEndpointArn);
        }

        public final String getDbClusterEndpointIdentifier() {
            return this.dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbClusterEndpointResourceIdentifier() {
            return this.dbClusterEndpointResourceIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
            return this;
        }

        public final void setDbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getCustomEndpointType() {
            return this.customEndpointType;
        }

        @Override
        public final Builder customEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
            return this;
        }

        public final void setCustomEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
        }

        public final Collection<String> getStaticMembers() {
            return this.staticMembers;
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String ... staticMembers) {
            this.staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        public final Collection<String> getExcludedMembers() {
            return this.excludedMembers;
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String ... excludedMembers) {
            this.excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        public final String getDbClusterEndpointArn() {
            return this.dbClusterEndpointArn;
        }

        @Override
        public final Builder dbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
            return this;
        }

        public final void setDbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
        }

        public DBClusterEndpoint build() {
            return new DBClusterEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterEndpoint> {
        public Builder dbClusterEndpointIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterEndpointResourceIdentifier(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);

        public Builder endpointType(String var1);

        public Builder customEndpointType(String var1);

        public Builder staticMembers(Collection<String> var1);

        public Builder staticMembers(String ... var1);

        public Builder excludedMembers(Collection<String> var1);

        public Builder excludedMembers(String ... var1);

        public Builder dbClusterEndpointArn(String var1);
    }
}

