/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbSnapshotsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeDbSnapshotsRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::dbInstanceIdentifier)).setter(DescribeDbSnapshotsRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::dbSnapshotIdentifier)).setter(DescribeDbSnapshotsRequest.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::snapshotType)).setter(DescribeDbSnapshotsRequest.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::filters)).setter(DescribeDbSnapshotsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::maxRecords)).setter(DescribeDbSnapshotsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::marker)).setter(DescribeDbSnapshotsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::includeShared)).setter(DescribeDbSnapshotsRequest.setter(Builder::includeShared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeShared").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::includePublic)).setter(DescribeDbSnapshotsRequest.setter(Builder::includePublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePublic").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSnapshotsRequest.getter(DescribeDbSnapshotsRequest::dbiResourceId)).setter(DescribeDbSnapshotsRequest.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, DB_SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_TYPE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, INCLUDE_SHARED_FIELD, INCLUDE_PUBLIC_FIELD, DBI_RESOURCE_ID_FIELD));
    private final String dbInstanceIdentifier;
    private final String dbSnapshotIdentifier;
    private final String snapshotType;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean includeShared;
    private final Boolean includePublic;
    private final String dbiResourceId;

    private DescribeDbSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.includeShared = builder.includeShared;
        this.includePublic = builder.includePublic;
        this.dbiResourceId = builder.dbiResourceId;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean includeShared() {
        return this.includeShared;
    }

    public Boolean includePublic() {
        return this.includePublic;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeShared());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSnapshotsRequest)) {
            return false;
        }
        DescribeDbSnapshotsRequest other = (DescribeDbSnapshotsRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.includeShared(), other.includeShared()) && Objects.equals(this.includePublic(), other.includePublic()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbSnapshotsRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("SnapshotType", (Object)this.snapshotType()).add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("IncludeShared", (Object)this.includeShared()).add("IncludePublic", (Object)this.includePublic()).add("DbiResourceId", (Object)this.dbiResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "IncludeShared": {
                return Optional.ofNullable(clazz.cast(this.includeShared()));
            }
            case "IncludePublic": {
                return Optional.ofNullable(clazz.cast(this.includePublic()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeDbSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbSnapshotIdentifier;
        private String snapshotType;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;
        private Boolean includeShared;
        private Boolean includePublic;
        private String dbiResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSnapshotsRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.snapshotType(model.snapshotType);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.includeShared(model.includeShared);
            this.includePublic(model.includePublic);
            this.dbiResourceId(model.dbiResourceId);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIncludeShared() {
            return this.includeShared;
        }

        @Override
        public final Builder includeShared(Boolean includeShared) {
            this.includeShared = includeShared;
            return this;
        }

        public final void setIncludeShared(Boolean includeShared) {
            this.includeShared = includeShared;
        }

        public final Boolean getIncludePublic() {
            return this.includePublic;
        }

        @Override
        public final Builder includePublic(Boolean includePublic) {
            this.includePublic = includePublic;
            return this;
        }

        public final void setIncludePublic(Boolean includePublic) {
            this.includePublic = includePublic;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbSnapshotsRequest build() {
            return new DescribeDbSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbSnapshotsRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbSnapshotIdentifier(String var1);

        public Builder snapshotType(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder includeShared(Boolean var1);

        public Builder includePublic(Boolean var1);

        public Builder dbiResourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

