/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.Endpoint;

public class EndpointUnmarshaller
implements Unmarshaller<Endpoint, StaxUnmarshallerContext> {
    private static final EndpointUnmarshaller INSTANCE = new EndpointUnmarshaller();

    public Endpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Endpoint.Builder endpoint = Endpoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Address", targetDepth)) {
                    endpoint.address(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    endpoint.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HostedZoneId", targetDepth)) continue;
                endpoint.hostedZoneId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Endpoint)endpoint.build();
    }

    public static EndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

