/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public class DescribeReservedDBInstancesPublisher
implements SdkPublisher<DescribeReservedDBInstancesResponse> {
    private final RDSAsyncClient client;
    private final DescribeReservedDBInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedDBInstancesPublisher(RDSAsyncClient client, DescribeReservedDBInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedDBInstancesPublisher(RDSAsyncClient client, DescribeReservedDBInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedDBInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedDBInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDBInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstances() != null) {
                return response.reservedDBInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedDBInstancesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedDBInstancesPublisher resume(DescribeReservedDBInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedDBInstancesPublisher(this.client, (DescribeReservedDBInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedDBInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedDBInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedDBInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedDBInstancesResponse> {
        private DescribeReservedDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeReservedDBInstancesResponse> nextPage(DescribeReservedDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesPublisher.this.client.describeReservedDBInstances(DescribeReservedDBInstancesPublisher.this.firstRequest);
            }
            return DescribeReservedDBInstancesPublisher.this.client.describeReservedDBInstances((DescribeReservedDBInstancesRequest)((Object)DescribeReservedDBInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

