/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsResponse;

public class DescribeDBParameterGroupsIterable
implements SdkIterable<DescribeDBParameterGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParameterGroupsIterable(RDSClient client, DescribeDBParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDBParameterGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDBParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbParameterGroups() != null) {
                return response.dbParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBParameterGroupsIterable resume(DescribeDBParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParameterGroupsIterable(this.client, (DescribeDBParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParameterGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBParameterGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDBParameterGroupsResponse> {
        private DescribeDBParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBParameterGroupsResponse nextPage(DescribeDBParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups(DescribeDBParameterGroupsIterable.this.firstRequest);
            }
            return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups((DescribeDBParameterGroupsRequest)((Object)DescribeDBParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

