/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesResponse;

public class DescribeDBLogFilesIterable
implements SdkIterable<DescribeDBLogFilesResponse> {
    private final RDSClient client;
    private final DescribeDBLogFilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBLogFilesIterable(RDSClient client, DescribeDBLogFilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBLogFilesResponseFetcher();
    }

    public Iterator<DescribeDBLogFilesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDBLogFilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.describeDBLogFiles() != null) {
                return response.describeDBLogFiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBLogFilesIterable resume(DescribeDBLogFilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBLogFilesIterable(this.client, (DescribeDBLogFilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBLogFilesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBLogFilesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBLogFilesResponseFetcher
    implements SyncPageFetcher<DescribeDBLogFilesResponse> {
        private DescribeDBLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBLogFilesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBLogFilesResponse nextPage(DescribeDBLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesIterable.this.client.describeDBLogFiles(DescribeDBLogFilesIterable.this.firstRequest);
            }
            return DescribeDBLogFilesIterable.this.client.describeDBLogFiles((DescribeDBLogFilesRequest)((Object)DescribeDBLogFilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

