/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PendingMaintenanceAction
implements ToCopyableBuilder<Builder, PendingMaintenanceAction> {
    private final String action;
    private final Instant autoAppliedAfterDate;
    private final Instant forcedApplyDate;
    private final String optInStatus;
    private final Instant currentApplyDate;
    private final String description;

    private PendingMaintenanceAction(BuilderImpl builder) {
        this.action = builder.action;
        this.autoAppliedAfterDate = builder.autoAppliedAfterDate;
        this.forcedApplyDate = builder.forcedApplyDate;
        this.optInStatus = builder.optInStatus;
        this.currentApplyDate = builder.currentApplyDate;
        this.description = builder.description;
    }

    public String action() {
        return this.action;
    }

    public Instant autoAppliedAfterDate() {
        return this.autoAppliedAfterDate;
    }

    public Instant forcedApplyDate() {
        return this.forcedApplyDate;
    }

    public String optInStatus() {
        return this.optInStatus;
    }

    public Instant currentApplyDate() {
        return this.currentApplyDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAppliedAfterDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.forcedApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenanceAction)) {
            return false;
        }
        PendingMaintenanceAction other = (PendingMaintenanceAction)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.autoAppliedAfterDate(), other.autoAppliedAfterDate()) && Objects.equals(this.forcedApplyDate(), other.forcedApplyDate()) && Objects.equals(this.optInStatus(), other.optInStatus()) && Objects.equals(this.currentApplyDate(), other.currentApplyDate()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"PendingMaintenanceAction").add("Action", (Object)this.action()).add("AutoAppliedAfterDate", (Object)this.autoAppliedAfterDate()).add("ForcedApplyDate", (Object)this.forcedApplyDate()).add("OptInStatus", (Object)this.optInStatus()).add("CurrentApplyDate", (Object)this.currentApplyDate()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.action()));
            }
            case "AutoAppliedAfterDate": {
                return Optional.of(clazz.cast(this.autoAppliedAfterDate()));
            }
            case "ForcedApplyDate": {
                return Optional.of(clazz.cast(this.forcedApplyDate()));
            }
            case "OptInStatus": {
                return Optional.of(clazz.cast(this.optInStatus()));
            }
            case "CurrentApplyDate": {
                return Optional.of(clazz.cast(this.currentApplyDate()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Instant autoAppliedAfterDate;
        private Instant forcedApplyDate;
        private String optInStatus;
        private Instant currentApplyDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenanceAction model) {
            this.action(model.action);
            this.autoAppliedAfterDate(model.autoAppliedAfterDate);
            this.forcedApplyDate(model.forcedApplyDate);
            this.optInStatus(model.optInStatus);
            this.currentApplyDate(model.currentApplyDate);
            this.description(model.description);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Instant getAutoAppliedAfterDate() {
            return this.autoAppliedAfterDate;
        }

        @Override
        public final Builder autoAppliedAfterDate(Instant autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
            return this;
        }

        public final void setAutoAppliedAfterDate(Instant autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
        }

        public final Instant getForcedApplyDate() {
            return this.forcedApplyDate;
        }

        @Override
        public final Builder forcedApplyDate(Instant forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
            return this;
        }

        public final void setForcedApplyDate(Instant forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
        }

        public final String getOptInStatus() {
            return this.optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        public final Instant getCurrentApplyDate() {
            return this.currentApplyDate;
        }

        @Override
        public final Builder currentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
            return this;
        }

        public final void setCurrentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public PendingMaintenanceAction build() {
            return new PendingMaintenanceAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingMaintenanceAction> {
        public Builder action(String var1);

        public Builder autoAppliedAfterDate(Instant var1);

        public Builder forcedApplyDate(Instant var1);

        public Builder optInStatus(String var1);

        public Builder currentApplyDate(Instant var1);

        public Builder description(String var1);
    }
}

