/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupsRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, DescribeOptionGroupsRequest> {
    private final String optionGroupName;
    private final List<Filter> filters;
    private final String marker;
    private final Integer maxRecords;
    private final String engineName;
    private final String majorEngineVersion;

    private DescribeOptionGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.optionGroupName = builder.optionGroupName;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsRequest)) {
            return false;
        }
        DescribeOptionGroupsRequest other = (DescribeOptionGroupsRequest)((Object)obj);
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOptionGroupsRequest").add("OptionGroupName", (Object)this.optionGroupName()).add("Filters", this.filters()).add("Marker", (Object)this.marker()).add("MaxRecords", (Object)this.maxRecords()).add("EngineName", (Object)this.engineName()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "EngineName": {
                return Optional.of(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.of(clazz.cast(this.majorEngineVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String optionGroupName;
        private List<Filter> filters;
        private String marker;
        private Integer maxRecords;
        private String engineName;
        private String majorEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsRequest model) {
            this.optionGroupName(model.optionGroupName);
            this.filters(model.filters);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeOptionGroupsRequest build() {
            return new DescribeOptionGroupsRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, DescribeOptionGroupsRequest> {
        public Builder optionGroupName(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

