/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupsCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSecurityGroupsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBSecurityGroupsResponse> {
    private final String marker;
    private final List<DBSecurityGroup> dbSecurityGroups;

    private DescribeDBSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSecurityGroups = builder.dbSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSecurityGroup> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSecurityGroupsResponse)) {
            return false;
        }
        DescribeDBSecurityGroupsResponse other = (DescribeDBSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBSecurityGroupsResponse").add("Marker", (Object)this.marker()).add("DBSecurityGroups", this.dbSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBSecurityGroups": {
                return Optional.of(clazz.cast(this.dbSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSecurityGroup> dbSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSecurityGroupsResponse model) {
            this.marker(model.marker);
            this.dbSecurityGroups(model.dbSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSecurityGroup.Builder> getDBSecurityGroups() {
            return this.dbSecurityGroups != null ? (Collection)this.dbSecurityGroups.stream().map(DBSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroup ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDBSecurityGroups(Collection<DBSecurityGroup.BuilderImpl> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copyFromBuilder(dbSecurityGroups);
        }

        @Override
        public DescribeDBSecurityGroupsResponse build() {
            return new DescribeDBSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSecurityGroups(Collection<DBSecurityGroup> var1);

        public Builder dbSecurityGroups(DBSecurityGroup ... var1);
    }
}

