/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBParametersRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, DescribeDBParametersRequest> {
    private final String dbParameterGroupName;
    private final String source;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeDBParametersRequest(BuilderImpl builder) {
        super(builder);
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.source = builder.source;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public String source() {
        return this.source;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBParametersRequest)) {
            return false;
        }
        DescribeDBParametersRequest other = (DescribeDBParametersRequest)((Object)obj);
        return Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBParametersRequest").add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("Source", (Object)this.source()).add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupName": {
                return Optional.of(clazz.cast(this.dbParameterGroupName()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbParameterGroupName;
        private String source;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBParametersRequest model) {
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.source(model.source);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDBParametersRequest build() {
            return new DescribeDBParametersRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, DescribeDBParametersRequest> {
        public Builder dbParameterGroupName(String var1);

        public Builder source(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

