/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroupListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClusterParameterGroupsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBClusterParameterGroupsResponse> {
    private final String marker;
    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDBClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return this.dbClusterParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDBClusterParameterGroupsResponse other = (DescribeDBClusterParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusterParameterGroups(), other.dbClusterParameterGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBClusterParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBClusterParameterGroups", this.dbClusterParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBClusterParameterGroups": {
                return Optional.of(clazz.cast(this.dbClusterParameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterParameterGroup> dbClusterParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClusterParameterGroupsResponse model) {
            this.marker(model.marker);
            this.dbClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterParameterGroup.Builder> getDBClusterParameterGroups() {
            return this.dbClusterParameterGroups != null ? (Collection)this.dbClusterParameterGroups.stream().map(DBClusterParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        public final void setDBClusterParameterGroups(Collection<DBClusterParameterGroup.BuilderImpl> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copyFromBuilder(dbClusterParameterGroups);
        }

        @Override
        public DescribeDBClusterParameterGroupsResponse build() {
            return new DescribeDBClusterParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> var1);

        public Builder dbClusterParameterGroups(DBClusterParameterGroup ... var1);
    }
}

