/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBClusterSnapshotRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CopyDBClusterSnapshotRequest> {
    private final String sourceDBClusterSnapshotIdentifier;
    private final String targetDBClusterSnapshotIdentifier;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean copyTags;
    private final List<Tag> tags;

    private CopyDBClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterSnapshotIdentifier = builder.sourceDBClusterSnapshotIdentifier;
        this.targetDBClusterSnapshotIdentifier = builder.targetDBClusterSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.copyTags = builder.copyTags;
        this.tags = builder.tags;
    }

    public String sourceDBClusterSnapshotIdentifier() {
        return this.sourceDBClusterSnapshotIdentifier;
    }

    public String targetDBClusterSnapshotIdentifier() {
        return this.targetDBClusterSnapshotIdentifier;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterSnapshotRequest)) {
            return false;
        }
        CopyDBClusterSnapshotRequest other = (CopyDBClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceDBClusterSnapshotIdentifier(), other.sourceDBClusterSnapshotIdentifier()) && Objects.equals(this.targetDBClusterSnapshotIdentifier(), other.targetDBClusterSnapshotIdentifier()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CopyDBClusterSnapshotRequest").add("SourceDBClusterSnapshotIdentifier", (Object)this.sourceDBClusterSnapshotIdentifier()).add("TargetDBClusterSnapshotIdentifier", (Object)this.targetDBClusterSnapshotIdentifier()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("CopyTags", (Object)this.copyTags()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.sourceDBClusterSnapshotIdentifier()));
            }
            case "TargetDBClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.targetDBClusterSnapshotIdentifier()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.of(clazz.cast(this.preSignedUrl()));
            }
            case "CopyTags": {
                return Optional.of(clazz.cast(this.copyTags()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String sourceDBClusterSnapshotIdentifier;
        private String targetDBClusterSnapshotIdentifier;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean copyTags;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBClusterSnapshotRequest model) {
            this.sourceDBClusterSnapshotIdentifier(model.sourceDBClusterSnapshotIdentifier);
            this.targetDBClusterSnapshotIdentifier(model.targetDBClusterSnapshotIdentifier);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.copyTags(model.copyTags);
            this.tags(model.tags);
        }

        public final String getSourceDBClusterSnapshotIdentifier() {
            return this.sourceDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
        }

        public final String getTargetDBClusterSnapshotIdentifier() {
            return this.targetDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CopyDBClusterSnapshotRequest build() {
            return new CopyDBClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CopyDBClusterSnapshotRequest> {
        public Builder sourceDBClusterSnapshotIdentifier(String var1);

        public Builder targetDBClusterSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder copyTags(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

