/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;

public final class DescribeReservedDBInstancesOfferingsPaginator
implements SdkIterable<DescribeReservedDBInstancesOfferingsResponse> {
    private final RDSClient client;
    private final DescribeReservedDBInstancesOfferingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesOfferingsPaginator(RDSClient client, DescribeReservedDBInstancesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDBInstancesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedDBInstancesOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        Function<DescribeReservedDBInstancesOfferingsResponse, Iterator> getIterator = response -> response != null ? response.reservedDBInstancesOfferings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedDBInstancesOfferingsResponseFetcher
    implements NextPageFetcher<DescribeReservedDBInstancesOfferingsResponse> {
        private DescribeReservedDBInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedDBInstancesOfferingsResponse nextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesOfferingsPaginator.this.client.describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsPaginator.this.firstRequest);
            }
            return DescribeReservedDBInstancesOfferingsPaginator.this.client.describeReservedDBInstancesOfferings((DescribeReservedDBInstancesOfferingsRequest)((Object)DescribeReservedDBInstancesOfferingsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

