/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;

public final class DescribeOptionGroupOptionsPaginator
implements SdkIterable<DescribeOptionGroupOptionsResponse> {
    private final RDSClient client;
    private final DescribeOptionGroupOptionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeOptionGroupOptionsPaginator(RDSClient client, DescribeOptionGroupOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptionGroupOptionsResponseFetcher();
    }

    public Iterator<DescribeOptionGroupOptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OptionGroupOption> optionGroupOptions() {
        Function<DescribeOptionGroupOptionsResponse, Iterator> getIterator = response -> response != null ? response.optionGroupOptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeOptionGroupOptionsResponseFetcher
    implements NextPageFetcher<DescribeOptionGroupOptionsResponse> {
        private DescribeOptionGroupOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOptionGroupOptionsResponse nextPage(DescribeOptionGroupOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupOptionsPaginator.this.client.describeOptionGroupOptions(DescribeOptionGroupOptionsPaginator.this.firstRequest);
            }
            return DescribeOptionGroupOptionsPaginator.this.client.describeOptionGroupOptions((DescribeOptionGroupOptionsRequest)((Object)DescribeOptionGroupOptionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

