/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsResponse;

public final class DescribeDBEngineVersionsPaginator
implements SdkIterable<DescribeDBEngineVersionsResponse> {
    private final RDSClient client;
    private final DescribeDBEngineVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBEngineVersionsPaginator(RDSClient client, DescribeDBEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeDBEngineVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDBEngineVersionsResponse, Iterator> getIterator = response -> response != null ? response.dbEngineVersions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBEngineVersionsResponseFetcher
    implements NextPageFetcher<DescribeDBEngineVersionsResponse> {
        private DescribeDBEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBEngineVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBEngineVersionsResponse nextPage(DescribeDBEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsPaginator.this.client.describeDBEngineVersions(DescribeDBEngineVersionsPaginator.this.firstRequest);
            }
            return DescribeDBEngineVersionsPaginator.this.client.describeDBEngineVersions((DescribeDBEngineVersionsRequest)((Object)DescribeDBEngineVersionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

