/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseReservedDBInstancesOfferingRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, PurchaseReservedDBInstancesOfferingRequest> {
    private final String reservedDBInstancesOfferingId;
    private final String reservedDBInstanceId;
    private final Integer dbInstanceCount;
    private final List<Tag> tags;

    private PurchaseReservedDBInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.tags = builder.tags;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public Integer dbInstanceCount() {
        return this.dbInstanceCount;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedDBInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedDBInstancesOfferingRequest other = (PurchaseReservedDBInstancesOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.reservedDBInstanceId(), other.reservedDBInstanceId()) && Objects.equals(this.dbInstanceCount(), other.dbInstanceCount()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservedDBInstancesOfferingId() != null) {
            sb.append("ReservedDBInstancesOfferingId: ").append(this.reservedDBInstancesOfferingId()).append(",");
        }
        if (this.reservedDBInstanceId() != null) {
            sb.append("ReservedDBInstanceId: ").append(this.reservedDBInstanceId()).append(",");
        }
        if (this.dbInstanceCount() != null) {
            sb.append("DBInstanceCount: ").append(this.dbInstanceCount()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "ReservedDBInstanceId": {
                return Optional.of(clazz.cast(this.reservedDBInstanceId()));
            }
            case "DBInstanceCount": {
                return Optional.of(clazz.cast(this.dbInstanceCount()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String reservedDBInstancesOfferingId;
        private String reservedDBInstanceId;
        private Integer dbInstanceCount;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedDBInstancesOfferingRequest model) {
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.dbInstanceCount(model.dbInstanceCount);
            this.tags(model.tags);
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final Integer getDBInstanceCount() {
            return this.dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDBInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedDBInstancesOfferingRequest build() {
            return new PurchaseReservedDBInstancesOfferingRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, PurchaseReservedDBInstancesOfferingRequest> {
        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder reservedDBInstanceId(String var1);

        public Builder dbInstanceCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

