/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBInstanceStatusInfo
implements ToCopyableBuilder<Builder, DBInstanceStatusInfo> {
    private final String statusType;
    private final Boolean normal;
    private final String status;
    private final String message;

    private DBInstanceStatusInfo(BuilderImpl builder) {
        this.statusType = builder.statusType;
        this.normal = builder.normal;
        this.status = builder.status;
        this.message = builder.message;
    }

    public String statusType() {
        return this.statusType;
    }

    public Boolean normal() {
        return this.normal;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusType());
        hashCode = 31 * hashCode + Objects.hashCode(this.normal());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstanceStatusInfo)) {
            return false;
        }
        DBInstanceStatusInfo other = (DBInstanceStatusInfo)obj;
        return Objects.equals(this.statusType(), other.statusType()) && Objects.equals(this.normal(), other.normal()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusType() != null) {
            sb.append("StatusType: ").append(this.statusType()).append(",");
        }
        if (this.normal() != null) {
            sb.append("Normal: ").append(this.normal()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusType": {
                return Optional.of(clazz.cast(this.statusType()));
            }
            case "Normal": {
                return Optional.of(clazz.cast(this.normal()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String statusType;
        private Boolean normal;
        private String status;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstanceStatusInfo model) {
            this.statusType(model.statusType);
            this.normal(model.normal);
            this.status(model.status);
            this.message(model.message);
        }

        public final String getStatusType() {
            return this.statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        public final Boolean getNormal() {
            return this.normal;
        }

        @Override
        public final Builder normal(Boolean normal) {
            this.normal = normal;
            return this;
        }

        public final void setNormal(Boolean normal) {
            this.normal = normal;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public DBInstanceStatusInfo build() {
            return new DBInstanceStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBInstanceStatusInfo> {
        public Builder statusType(String var1);

        public Builder normal(Boolean var1);

        public Builder status(String var1);

        public Builder message(String var1);
    }
}

