/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthorizeDBSecurityGroupIngressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AuthorizeDBSecurityGroupIngressRequest> {
    private final String dbSecurityGroupName;
    private final String cidrip;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupId;
    private final String ec2SecurityGroupOwnerId;

    private AuthorizeDBSecurityGroupIngressRequest(BuilderImpl builder) {
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public String cidrip() {
        return this.cidrip;
    }

    public String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public String ec2SecurityGroupId() {
        return this.ec2SecurityGroupId;
    }

    public String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeDBSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeDBSecurityGroupIngressRequest other = (AuthorizeDBSecurityGroupIngressRequest)((Object)obj);
        return Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(this.cidrip(), other.cidrip()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupId(), other.ec2SecurityGroupId()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: ").append(this.dbSecurityGroupName()).append(",");
        }
        if (this.cidrip() != null) {
            sb.append("CIDRIP: ").append(this.cidrip()).append(",");
        }
        if (this.ec2SecurityGroupName() != null) {
            sb.append("EC2SecurityGroupName: ").append(this.ec2SecurityGroupName()).append(",");
        }
        if (this.ec2SecurityGroupId() != null) {
            sb.append("EC2SecurityGroupId: ").append(this.ec2SecurityGroupId()).append(",");
        }
        if (this.ec2SecurityGroupOwnerId() != null) {
            sb.append("EC2SecurityGroupOwnerId: ").append(this.ec2SecurityGroupOwnerId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSecurityGroupName": {
                return Optional.of(clazz.cast(this.dbSecurityGroupName()));
            }
            case "CIDRIP": {
                return Optional.of(clazz.cast(this.cidrip()));
            }
            case "EC2SecurityGroupName": {
                return Optional.of(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupId": {
                return Optional.of(clazz.cast(this.ec2SecurityGroupId()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.of(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSecurityGroupName;
        private String cidrip;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupId;
        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeDBSecurityGroupIngressRequest model) {
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.cidrip(model.cidrip);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupId(model.ec2SecurityGroupId);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getDBSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDBSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getCIDRIP() {
            return this.cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCIDRIP(String cidrip) {
            this.cidrip = cidrip;
        }

        public final String getEC2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEC2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEC2SecurityGroupId() {
            return this.ec2SecurityGroupId;
        }

        @Override
        public final Builder ec2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
            return this;
        }

        public final void setEC2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
        }

        public final String getEC2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEC2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        public AuthorizeDBSecurityGroupIngressRequest build() {
            return new AuthorizeDBSecurityGroupIngressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthorizeDBSecurityGroupIngressRequest> {
        public Builder dbSecurityGroupName(String var1);

        public Builder cidrip(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupId(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);
    }
}

