/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDBClusterRequest;

public class RemoveRoleFromDBClusterRequestMarshaller
implements Marshaller<Request<RemoveRoleFromDBClusterRequest>, RemoveRoleFromDBClusterRequest> {
    public Request<RemoveRoleFromDBClusterRequest> marshall(RemoveRoleFromDBClusterRequest removeRoleFromDBClusterRequest) {
        if (removeRoleFromDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeRoleFromDBClusterRequest, "RDSClient");
        request.addParameter("Action", "RemoveRoleFromDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeRoleFromDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)removeRoleFromDBClusterRequest.dbClusterIdentifier()));
        }
        if (removeRoleFromDBClusterRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)removeRoleFromDBClusterRequest.roleArn()));
        }
        return request;
    }
}

