/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecurringCharge
implements ToCopyableBuilder<Builder, RecurringCharge> {
    private final Double recurringChargeAmount;
    private final String recurringChargeFrequency;

    private RecurringCharge(BuilderImpl builder) {
        this.recurringChargeAmount = builder.recurringChargeAmount;
        this.recurringChargeFrequency = builder.recurringChargeFrequency;
    }

    public Double recurringChargeAmount() {
        return this.recurringChargeAmount;
    }

    public String recurringChargeFrequency() {
        return this.recurringChargeFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recurringChargeAmount() == null ? 0 : this.recurringChargeAmount().hashCode());
        hashCode = 31 * hashCode + (this.recurringChargeFrequency() == null ? 0 : this.recurringChargeFrequency().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        if (other.recurringChargeAmount() == null ^ this.recurringChargeAmount() == null) {
            return false;
        }
        if (other.recurringChargeAmount() != null && !other.recurringChargeAmount().equals(this.recurringChargeAmount())) {
            return false;
        }
        if (other.recurringChargeFrequency() == null ^ this.recurringChargeFrequency() == null) {
            return false;
        }
        return other.recurringChargeFrequency() == null || other.recurringChargeFrequency().equals(this.recurringChargeFrequency());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recurringChargeAmount() != null) {
            sb.append("RecurringChargeAmount: ").append(this.recurringChargeAmount()).append(",");
        }
        if (this.recurringChargeFrequency() != null) {
            sb.append("RecurringChargeFrequency: ").append(this.recurringChargeFrequency()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecurringChargeAmount": {
                return Optional.of(clazz.cast(this.recurringChargeAmount()));
            }
            case "RecurringChargeFrequency": {
                return Optional.of(clazz.cast(this.recurringChargeFrequency()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double recurringChargeAmount;
        private String recurringChargeFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            this.recurringChargeAmount(model.recurringChargeAmount);
            this.recurringChargeFrequency(model.recurringChargeFrequency);
        }

        public final Double getRecurringChargeAmount() {
            return this.recurringChargeAmount;
        }

        @Override
        public final Builder recurringChargeAmount(Double recurringChargeAmount) {
            this.recurringChargeAmount = recurringChargeAmount;
            return this;
        }

        public final void setRecurringChargeAmount(Double recurringChargeAmount) {
            this.recurringChargeAmount = recurringChargeAmount;
        }

        public final String getRecurringChargeFrequency() {
            return this.recurringChargeFrequency;
        }

        @Override
        public final Builder recurringChargeFrequency(String recurringChargeFrequency) {
            this.recurringChargeFrequency = recurringChargeFrequency;
            return this;
        }

        public final void setRecurringChargeFrequency(String recurringChargeFrequency) {
            this.recurringChargeFrequency = recurringChargeFrequency;
        }

        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecurringCharge> {
        public Builder recurringChargeAmount(Double var1);

        public Builder recurringChargeFrequency(String var1);
    }
}

