/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IPRange
implements ToCopyableBuilder<Builder, IPRange> {
    private final String status;
    private final String cidrip;

    private IPRange(BuilderImpl builder) {
        this.status = builder.status;
        this.cidrip = builder.cidrip;
    }

    public String status() {
        return this.status;
    }

    public String cidrip() {
        return this.cidrip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.cidrip() == null ? 0 : this.cidrip().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.cidrip() == null ^ this.cidrip() == null) {
            return false;
        }
        return other.cidrip() == null || other.cidrip().equals(this.cidrip());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.cidrip() != null) {
            sb.append("CIDRIP: ").append(this.cidrip()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "CIDRIP": {
                return Optional.of(clazz.cast(this.cidrip()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String cidrip;

        private BuilderImpl() {
        }

        private BuilderImpl(IPRange model) {
            this.status(model.status);
            this.cidrip(model.cidrip);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCIDRIP() {
            return this.cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCIDRIP(String cidrip) {
            this.cidrip = cidrip;
        }

        public IPRange build() {
            return new IPRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPRange> {
        public Builder status(String var1);

        public Builder cidrip(String var1);
    }
}

