/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBClusterMember
implements ToCopyableBuilder<Builder, DBClusterMember> {
    private final String dbInstanceIdentifier;
    private final Boolean isClusterWriter;
    private final String dbClusterParameterGroupStatus;
    private final Integer promotionTier;

    private DBClusterMember(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.isClusterWriter = builder.isClusterWriter;
        this.dbClusterParameterGroupStatus = builder.dbClusterParameterGroupStatus;
        this.promotionTier = builder.promotionTier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Boolean isClusterWriter() {
        return this.isClusterWriter;
    }

    public String dbClusterParameterGroupStatus() {
        return this.dbClusterParameterGroupStatus;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.isClusterWriter() == null ? 0 : this.isClusterWriter().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterParameterGroupStatus() == null ? 0 : this.dbClusterParameterGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.promotionTier() == null ? 0 : this.promotionTier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterMember)) {
            return false;
        }
        DBClusterMember other = (DBClusterMember)obj;
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.isClusterWriter() == null ^ this.isClusterWriter() == null) {
            return false;
        }
        if (other.isClusterWriter() != null && !other.isClusterWriter().equals(this.isClusterWriter())) {
            return false;
        }
        if (other.dbClusterParameterGroupStatus() == null ^ this.dbClusterParameterGroupStatus() == null) {
            return false;
        }
        if (other.dbClusterParameterGroupStatus() != null && !other.dbClusterParameterGroupStatus().equals(this.dbClusterParameterGroupStatus())) {
            return false;
        }
        if (other.promotionTier() == null ^ this.promotionTier() == null) {
            return false;
        }
        return other.promotionTier() == null || other.promotionTier().equals(this.promotionTier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.isClusterWriter() != null) {
            sb.append("IsClusterWriter: ").append(this.isClusterWriter()).append(",");
        }
        if (this.dbClusterParameterGroupStatus() != null) {
            sb.append("DBClusterParameterGroupStatus: ").append(this.dbClusterParameterGroupStatus()).append(",");
        }
        if (this.promotionTier() != null) {
            sb.append("PromotionTier: ").append(this.promotionTier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "IsClusterWriter": {
                return Optional.of(clazz.cast(this.isClusterWriter()));
            }
            case "DBClusterParameterGroupStatus": {
                return Optional.of(clazz.cast(this.dbClusterParameterGroupStatus()));
            }
            case "PromotionTier": {
                return Optional.of(clazz.cast(this.promotionTier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean isClusterWriter;
        private String dbClusterParameterGroupStatus;
        private Integer promotionTier;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterMember model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.isClusterWriter(model.isClusterWriter);
            this.dbClusterParameterGroupStatus(model.dbClusterParameterGroupStatus);
            this.promotionTier(model.promotionTier);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getIsClusterWriter() {
            return this.isClusterWriter;
        }

        @Override
        public final Builder isClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
            return this;
        }

        public final void setIsClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
        }

        public final String getDBClusterParameterGroupStatus() {
            return this.dbClusterParameterGroupStatus;
        }

        @Override
        public final Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
            return this;
        }

        public final void setDBClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public DBClusterMember build() {
            return new DBClusterMember(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBClusterMember> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder isClusterWriter(Boolean var1);

        public Builder dbClusterParameterGroupStatus(String var1);

        public Builder promotionTier(Integer var1);
    }
}

