/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CharacterSet
implements ToCopyableBuilder<Builder, CharacterSet> {
    private final String characterSetName;
    private final String characterSetDescription;

    private CharacterSet(BuilderImpl builder) {
        this.characterSetName = builder.characterSetName;
        this.characterSetDescription = builder.characterSetDescription;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String characterSetDescription() {
        return this.characterSetDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.characterSetName() == null ? 0 : this.characterSetName().hashCode());
        hashCode = 31 * hashCode + (this.characterSetDescription() == null ? 0 : this.characterSetDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterSet)) {
            return false;
        }
        CharacterSet other = (CharacterSet)obj;
        if (other.characterSetName() == null ^ this.characterSetName() == null) {
            return false;
        }
        if (other.characterSetName() != null && !other.characterSetName().equals(this.characterSetName())) {
            return false;
        }
        if (other.characterSetDescription() == null ^ this.characterSetDescription() == null) {
            return false;
        }
        return other.characterSetDescription() == null || other.characterSetDescription().equals(this.characterSetDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.characterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.characterSetName()).append(",");
        }
        if (this.characterSetDescription() != null) {
            sb.append("CharacterSetDescription: ").append(this.characterSetDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CharacterSetName": {
                return Optional.of(clazz.cast(this.characterSetName()));
            }
            case "CharacterSetDescription": {
                return Optional.of(clazz.cast(this.characterSetDescription()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String characterSetName;
        private String characterSetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CharacterSet model) {
            this.characterSetName(model.characterSetName);
            this.characterSetDescription(model.characterSetDescription);
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getCharacterSetDescription() {
            return this.characterSetDescription;
        }

        @Override
        public final Builder characterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
            return this;
        }

        public final void setCharacterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
        }

        public CharacterSet build() {
            return new CharacterSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CharacterSet> {
        public Builder characterSetName(String var1);

        public Builder characterSetDescription(String var1);
    }
}

