/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.Subnet;
import software.amazon.awssdk.services.rds.model.SubnetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSubnetGroup
implements ToCopyableBuilder<Builder, DBSubnetGroup> {
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final String dbSubnetGroupArn;

    private DBSubnetGroup(BuilderImpl builder) {
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.dbSubnetGroupArn = builder.dbSubnetGroupArn;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public String dbSubnetGroupArn() {
        return this.dbSubnetGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupDescription() == null ? 0 : this.dbSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.subnetGroupStatus() == null ? 0 : this.subnetGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupArn() == null ? 0 : this.dbSubnetGroupArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSubnetGroup)) {
            return false;
        }
        DBSubnetGroup other = (DBSubnetGroup)obj;
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.dbSubnetGroupDescription() == null ^ this.dbSubnetGroupDescription() == null) {
            return false;
        }
        if (other.dbSubnetGroupDescription() != null && !other.dbSubnetGroupDescription().equals(this.dbSubnetGroupDescription())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.subnetGroupStatus() == null ^ this.subnetGroupStatus() == null) {
            return false;
        }
        if (other.subnetGroupStatus() != null && !other.subnetGroupStatus().equals(this.subnetGroupStatus())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        if (other.subnets() != null && !other.subnets().equals(this.subnets())) {
            return false;
        }
        if (other.dbSubnetGroupArn() == null ^ this.dbSubnetGroupArn() == null) {
            return false;
        }
        return other.dbSubnetGroupArn() == null || other.dbSubnetGroupArn().equals(this.dbSubnetGroupArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.dbSubnetGroupDescription() != null) {
            sb.append("DBSubnetGroupDescription: ").append(this.dbSubnetGroupDescription()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnetGroupStatus() != null) {
            sb.append("SubnetGroupStatus: ").append(this.subnetGroupStatus()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.dbSubnetGroupArn() != null) {
            sb.append("DBSubnetGroupArn: ").append(this.dbSubnetGroupArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets;
        private String dbSubnetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSubnetGroup model) {
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setDBSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.setVpcId(model.vpcId);
            this.setSubnetGroupStatus(model.subnetGroupStatus);
            this.setSubnets(model.subnets);
            this.setDBSubnetGroupArn(model.dbSubnetGroupArn);
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDBSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDBSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<Subnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
        }

        public final String getDBSubnetGroupArn() {
            return this.dbSubnetGroupArn;
        }

        @Override
        public final Builder dbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
            return this;
        }

        public final void setDBSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
        }

        public DBSubnetGroup build() {
            return new DBSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSubnetGroup> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder dbSubnetGroupArn(String var1);
    }
}

