/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroup;
import software.amazon.awssdk.services.rds.model.IPRange;
import software.amazon.awssdk.services.rds.transform.EC2SecurityGroupUnmarshaller;
import software.amazon.awssdk.services.rds.transform.IPRangeUnmarshaller;

public class DBSecurityGroupUnmarshaller
implements Unmarshaller<DBSecurityGroup, StaxUnmarshallerContext> {
    private static final DBSecurityGroupUnmarshaller INSTANCE = new DBSecurityGroupUnmarshaller();

    public DBSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBSecurityGroup.Builder dbSecurityGroup;
        block12: {
            dbSecurityGroup = DBSecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<EC2SecurityGroup> ec2SecurityGroups = null;
            ArrayList<IPRange> ipRanges = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    dbSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
                    dbSecurityGroup.ipRanges(ipRanges);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("OwnerId", targetDepth)) {
                        dbSecurityGroup.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupName", targetDepth)) {
                        dbSecurityGroup.dbSecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupDescription", targetDepth)) {
                        dbSecurityGroup.dbSecurityGroupDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        dbSecurityGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroups", targetDepth)) {
                        ec2SecurityGroups = new ArrayList<EC2SecurityGroup>();
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroups/EC2SecurityGroup", targetDepth)) {
                        ec2SecurityGroups.add(EC2SecurityGroupUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IPRanges", targetDepth)) {
                        ipRanges = new ArrayList<IPRange>();
                        continue;
                    }
                    if (context.testExpression("IPRanges/IPRange", targetDepth)) {
                        ipRanges.add(IPRangeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("DBSecurityGroupArn", targetDepth)) continue;
                    dbSecurityGroup.dbSecurityGroupArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            dbSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
            dbSecurityGroup.ipRanges(ipRanges);
        }
        return (DBSecurityGroup)dbSecurityGroup.build();
    }

    public static DBSecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

