/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.rds.model.SourceIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventSubscription
implements ToCopyableBuilder<Builder, EventSubscription> {
    private final String customerAwsId;
    private final String custSubscriptionId;
    private final String snsTopicArn;
    private final String status;
    private final String subscriptionCreationTime;
    private final String sourceType;
    private final List<String> sourceIdsList;
    private final List<String> eventCategoriesList;
    private final Boolean enabled;
    private final String eventSubscriptionArn;

    private EventSubscription(BuilderImpl builder) {
        this.customerAwsId = builder.customerAwsId;
        this.custSubscriptionId = builder.custSubscriptionId;
        this.snsTopicArn = builder.snsTopicArn;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
        this.sourceType = builder.sourceType;
        this.sourceIdsList = builder.sourceIdsList;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.enabled = builder.enabled;
        this.eventSubscriptionArn = builder.eventSubscriptionArn;
    }

    public String customerAwsId() {
        return this.customerAwsId;
    }

    public String custSubscriptionId() {
        return this.custSubscriptionId;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String status() {
        return this.status;
    }

    public String subscriptionCreationTime() {
        return this.subscriptionCreationTime;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> sourceIdsList() {
        return this.sourceIdsList;
    }

    public List<String> eventCategoriesList() {
        return this.eventCategoriesList;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String eventSubscriptionArn() {
        return this.eventSubscriptionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.customerAwsId() == null ? 0 : this.customerAwsId().hashCode());
        hashCode = 31 * hashCode + (this.custSubscriptionId() == null ? 0 : this.custSubscriptionId().hashCode());
        hashCode = 31 * hashCode + (this.snsTopicArn() == null ? 0 : this.snsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionCreationTime() == null ? 0 : this.subscriptionCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.sourceIdsList() == null ? 0 : this.sourceIdsList().hashCode());
        hashCode = 31 * hashCode + (this.eventCategoriesList() == null ? 0 : this.eventCategoriesList().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.eventSubscriptionArn() == null ? 0 : this.eventSubscriptionArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription)obj;
        if (other.customerAwsId() == null ^ this.customerAwsId() == null) {
            return false;
        }
        if (other.customerAwsId() != null && !other.customerAwsId().equals(this.customerAwsId())) {
            return false;
        }
        if (other.custSubscriptionId() == null ^ this.custSubscriptionId() == null) {
            return false;
        }
        if (other.custSubscriptionId() != null && !other.custSubscriptionId().equals(this.custSubscriptionId())) {
            return false;
        }
        if (other.snsTopicArn() == null ^ this.snsTopicArn() == null) {
            return false;
        }
        if (other.snsTopicArn() != null && !other.snsTopicArn().equals(this.snsTopicArn())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subscriptionCreationTime() == null ^ this.subscriptionCreationTime() == null) {
            return false;
        }
        if (other.subscriptionCreationTime() != null && !other.subscriptionCreationTime().equals(this.subscriptionCreationTime())) {
            return false;
        }
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.sourceIdsList() == null ^ this.sourceIdsList() == null) {
            return false;
        }
        if (other.sourceIdsList() != null && !other.sourceIdsList().equals(this.sourceIdsList())) {
            return false;
        }
        if (other.eventCategoriesList() == null ^ this.eventCategoriesList() == null) {
            return false;
        }
        if (other.eventCategoriesList() != null && !other.eventCategoriesList().equals(this.eventCategoriesList())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.eventSubscriptionArn() == null ^ this.eventSubscriptionArn() == null) {
            return false;
        }
        return other.eventSubscriptionArn() == null || other.eventSubscriptionArn().equals(this.eventSubscriptionArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customerAwsId() != null) {
            sb.append("CustomerAwsId: ").append(this.customerAwsId()).append(",");
        }
        if (this.custSubscriptionId() != null) {
            sb.append("CustSubscriptionId: ").append(this.custSubscriptionId()).append(",");
        }
        if (this.snsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.snsTopicArn()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.subscriptionCreationTime() != null) {
            sb.append("SubscriptionCreationTime: ").append(this.subscriptionCreationTime()).append(",");
        }
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.sourceIdsList() != null) {
            sb.append("SourceIdsList: ").append(this.sourceIdsList()).append(",");
        }
        if (this.eventCategoriesList() != null) {
            sb.append("EventCategoriesList: ").append(this.eventCategoriesList()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.eventSubscriptionArn() != null) {
            sb.append("EventSubscriptionArn: ").append(this.eventSubscriptionArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String customerAwsId;
        private String custSubscriptionId;
        private String snsTopicArn;
        private String status;
        private String subscriptionCreationTime;
        private String sourceType;
        private List<String> sourceIdsList;
        private List<String> eventCategoriesList;
        private Boolean enabled;
        private String eventSubscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            this.setCustomerAwsId(model.customerAwsId);
            this.setCustSubscriptionId(model.custSubscriptionId);
            this.setSnsTopicArn(model.snsTopicArn);
            this.setStatus(model.status);
            this.setSubscriptionCreationTime(model.subscriptionCreationTime);
            this.setSourceType(model.sourceType);
            this.setSourceIdsList(model.sourceIdsList);
            this.setEventCategoriesList(model.eventCategoriesList);
            this.setEnabled(model.enabled);
            this.setEventSubscriptionArn(model.eventSubscriptionArn);
        }

        public final String getCustomerAwsId() {
            return this.customerAwsId;
        }

        @Override
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        public final String getCustSubscriptionId() {
            return this.custSubscriptionId;
        }

        @Override
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubscriptionCreationTime() {
            return this.subscriptionCreationTime;
        }

        @Override
        public final Builder subscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        public final void setSubscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getSourceIdsList() {
            return this.sourceIdsList;
        }

        @Override
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIdsList(String ... sourceIdsList) {
            this.sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
        }

        public final Collection<String> getEventCategoriesList() {
            return this.eventCategoriesList;
        }

        @Override
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesList(String ... eventCategoriesList) {
            this.eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getEventSubscriptionArn() {
            return this.eventSubscriptionArn;
        }

        @Override
        public final Builder eventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
            return this;
        }

        public final void setEventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
        }

        public EventSubscription build() {
            return new EventSubscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventSubscription> {
        public Builder customerAwsId(String var1);

        public Builder custSubscriptionId(String var1);

        public Builder snsTopicArn(String var1);

        public Builder status(String var1);

        public Builder subscriptionCreationTime(String var1);

        public Builder sourceType(String var1);

        public Builder sourceIdsList(Collection<String> var1);

        public Builder sourceIdsList(String ... var1);

        public Builder eventCategoriesList(Collection<String> var1);

        public Builder eventCategoriesList(String ... var1);

        public Builder enabled(Boolean var1);

        public Builder eventSubscriptionArn(String var1);
    }
}

