/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateOptionGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateOptionGroupRequest> {
    private final String optionGroupName;
    private final String engineName;
    private final String majorEngineVersion;
    private final String optionGroupDescription;
    private final List<Tag> tags;

    private CreateOptionGroupRequest(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.optionGroupDescription = builder.optionGroupDescription;
        this.tags = builder.tags;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public String optionGroupDescription() {
        return this.optionGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.engineName() == null ? 0 : this.engineName().hashCode());
        hashCode = 31 * hashCode + (this.majorEngineVersion() == null ? 0 : this.majorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupDescription() == null ? 0 : this.optionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptionGroupRequest)) {
            return false;
        }
        CreateOptionGroupRequest other = (CreateOptionGroupRequest)((Object)obj);
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.engineName() == null ^ this.engineName() == null) {
            return false;
        }
        if (other.engineName() != null && !other.engineName().equals(this.engineName())) {
            return false;
        }
        if (other.majorEngineVersion() == null ^ this.majorEngineVersion() == null) {
            return false;
        }
        if (other.majorEngineVersion() != null && !other.majorEngineVersion().equals(this.majorEngineVersion())) {
            return false;
        }
        if (other.optionGroupDescription() == null ^ this.optionGroupDescription() == null) {
            return false;
        }
        if (other.optionGroupDescription() != null && !other.optionGroupDescription().equals(this.optionGroupDescription())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.engineName() != null) {
            sb.append("EngineName: ").append(this.engineName()).append(",");
        }
        if (this.majorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.majorEngineVersion()).append(",");
        }
        if (this.optionGroupDescription() != null) {
            sb.append("OptionGroupDescription: ").append(this.optionGroupDescription()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String optionGroupName;
        private String engineName;
        private String majorEngineVersion;
        private String optionGroupDescription;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptionGroupRequest model) {
            this.setOptionGroupName(model.optionGroupName);
            this.setEngineName(model.engineName);
            this.setMajorEngineVersion(model.majorEngineVersion);
            this.setOptionGroupDescription(model.optionGroupDescription);
            this.setTags(model.tags);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final String getOptionGroupDescription() {
            return this.optionGroupDescription;
        }

        @Override
        public final Builder optionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        public final void setOptionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public CreateOptionGroupRequest build() {
            return new CreateOptionGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateOptionGroupRequest> {
        public Builder optionGroupName(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder optionGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

