/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttribute;

public class DBSnapshotAttributeUnmarshaller
implements Unmarshaller<DBSnapshotAttribute, StaxUnmarshallerContext> {
    private static DBSnapshotAttributeUnmarshaller INSTANCE;

    public DBSnapshotAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBSnapshotAttribute.Builder dbSnapshotAttribute;
        block6: {
            dbSnapshotAttribute = DBSnapshotAttribute.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<String> attributeValues = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    dbSnapshotAttribute.attributeValues(attributeValues);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AttributeName", targetDepth)) {
                        dbSnapshotAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AttributeValues", targetDepth)) {
                        attributeValues = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("AttributeValues/AttributeValue", targetDepth)) continue;
                    attributeValues.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            dbSnapshotAttribute.attributeValues(attributeValues);
        }
        return (DBSnapshotAttribute)dbSnapshotAttribute.build();
    }

    public static DBSnapshotAttributeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBSnapshotAttributeUnmarshaller();
        }
        return INSTANCE;
    }
}

